/* File: list.h 
 *
 * Description:   
 *	            Simple list package. Each node is a structure with 
 * 	    a key and a void pointer to some arbitrary structure provided
 *	    by the user. The contents of the structure are free'd upon
 *	    destruction, however any dynamically allocated memory in the 
 *	    structure is not. The diff functions do not copy the structure 
 *	    into the diff lists, for the above reason.
 *
 *
 * Routines:	lnode *construct_lnode()
 *		void   destroy_lnode()
 *
 *		lnode *fwd_insert_lnode()	Sorted insertion 
 *		lnode *rev_insert_lnode()
 *
 *		lnode *delete_lnode()		Find and delete 
 *		lnode *remove_lnode()		Find and remove 
 *
 *		lnode *free_list()
 *
 *		lnode *dup_list()
 *		
 *		lnode *merge_lists();
 *
 *		void    diff_fwd_lists();
 *		void    diff_rev_lists();
 *
 *		int    match_list();
 *		lnode *find_lnode()
 *
 *		int    lists_equal();
 *		int    lists_not_equal();
 *
 *		void    print_list();
 *
 * For Stacks and unsorted lists
 *
 *		lnode *push_lnode()	
 *		lnode *pop_lnode()	
 *		lnode *append_lnode()	
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *            
 */


#ifndef LISTH
#define LISTH


typedef struct _lnode {
	int 		 key;
	void		*data;		/* Arbitrary data pointer */
	struct _lnode 	*next;
} lnode;

#define NULL_LNODE_PTR	(lnode *)(0)

#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif

extern int _new_list_entry;		/* Set when new entry added */

lnode *construct_lnode();
void   destroy_lnode();
lnode *fwd_insert_lnode();
lnode *rev_insert_lnode();
lnode *delete_lnode();			/* Find and destroy */
lnode *remove_lnode();			/* Find and destroy, but not contents */
lnode *free_list();

lnode	*dup_list();
lnode   *merge_lists();

void	diff_fwd_lists();
void	diff_rev_lists();
int	match_list();
lnode  *find_lnode();
int	lists_equal();
int	lists_not_equal();

void	print_list();

lnode *push_lnode();
lnode *pop_lnode();
lnode *append_lnode();

#ifndef True
#define	True	1
#endif

#ifndef False
#define False 	0
#endif

#endif /* LISTH */
