/* File: dup_list.c 
 *
 * Description:   
 *	        Create an exact duplicate of the supplied list.
 *
 *		NOTE: data contents are not copied!! However the data
 *		pointer is set to point to the original data contents.
 *		Be very careful when deleting lists created with dup!!!
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into separate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */


lnode
*dup_list( list )
lnode *list;
{
	lnode *p;
	lnode *new_list=NULL_LNODE_PTR;
	lnode *new; 
	lnode *last=NULL_LNODE_PTR;

	
	for ( p = list ; p != NULL_LNODE_PTR; p = p->next )
	{
		new = construct_lnode( p->key, p->data );

		if ( new_list == NULL_LNODE_PTR )
			new_list = new;
		else
			last->next = new;

		last = new;
	}

	return( new_list );
}
