/* File: diff_fwd_lists.c 
 *
 * Description:   
 *	        Create a list of addition and deletions required to modify
 *		the old list to create the new list.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into separate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */


void
diff_fwd_lists( old, new, add, del )
lnode *old;
lnode *new;
lnode **add;
lnode **del;
{
	lnode *add_list=NULL_LNODE_PTR;
	lnode *del_list=NULL_LNODE_PTR;
	lnode *n, *p;

	/* Need to modify, like diff_rev_lists */

	add_list = free_list( *add );
	for ( n = new; n != NULL_LNODE_PTR ; n = n->next )
	{
		for ( p = old; p != NULL_LNODE_PTR; p = p->next )
		{
			if ( n->key == p->key )
				break;
		}

		if ( p == NULL_LNODE_PTR )  /* Not found in list */
			add_list = fwd_insert_lnode( add_list, n->key, NULL );
	}

	/* Build list of nodes that have disappeared */

	del_list = free_list( *del );
	for ( p = old; p != NULL_LNODE_PTR ; p = p->next )
	{
		for ( n = new; n != NULL_LNODE_PTR; n = n->next )
		{
			if ( n->key == p->key )
				break;
		}

		if ( n == NULL_LNODE_PTR )  /* Not found in list */
			del_list = fwd_insert_lnode( del_list, p->key, NULL );
	}

	*add = add_list;
	*del = del_list;
}
