/* File: append_lnode.c 
 *
 * Description:   
 *	        Create and append a new lnode in the supplied list without
 *		maintaining ordering. Return the modified list.
 *
 *		NOTE: no check for duplication is done
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995-2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	12/29/2001	Created
 *            
 */

#include <stdio.h>

#include "list.h"	/* Package definitions */


lnode
*append_lnode( list, key, data )
lnode *list;
int    key;
void  *data;
{
	lnode *new_node, *ptr;

	new_node = construct_lnode( key, data );
	if ( new_node == NULL_LNODE_PTR )
		return( list );

	if ( list == NULL_LNODE_PTR )
		list = new_node;
	else
	{
		for ( ptr = list; ptr->next != NULL_LNODE_PTR; ptr = ptr->next )
			;

		ptr->next = new_node;
	}

	return( list );
}

