
/* -------------------  User Group Defines  -------------------- */

#ifndef LISTH
#include "list.h"
#endif

typedef struct _group_info {
	struct group       *g;
	struct _group_info *next;
} Group_info;

typedef struct _passwd_info {
	struct passwd       *p;
	struct _passwd_info *next;
} Passwd_info;

/* The following defines are used in the user group info structure  */

#define UNINITIALIZED		0
#define INITIALIZED		1

#define NO_DIALOG		0
#define DIALOG_DISPLAYED	1
#define DIALOG_HIDDEN		2

#define VIEW_NO_USERS		0
#define VIEW_IGNORE_USERS	0
#define VIEW_ALL_USERS		1
#define VIEW_LOGGED_IN_USER	2
#define VIEW_ROOT_USER		3
#define VIEW_UUCP_USER		4
#define VIEW_LOGGED_IN_USERS	5
#define VIEW_BACKGROUND_USERS	6
#define VIEW_ACTIVE_USERS	7
#define VIEW_SELECTED_USER_LIST	8
#define VIEW_GUTREE		9

#define VIEW_IGNORE_GROUPS	0
#define VIEW_ALL_GROUPS		1
#define VIEW_LOGGED_IN_GROUP	2
#define VIEW_LOGGED_IN_GROUPS	3
#define VIEW_BACKGROUND_GROUPS	4
#define VIEW_ACTIVE_GROUPS	5
#define VIEW_SELECTED_GROUP_LIST 6

typedef struct _user_group_info {
	int	      state;
	int	      dialog_state;
	int 	      group_view;	 /* Group view selction criteria */
	int 	      user_view;	 /* User view selection criteria */
	lnode        *user_display_list; /* Custom selected user list    */	
	lnode        *group_display_list;/* Custom selected group list   */

	int	      monitor_users;	 /* When  set the following two  */
					 /* items are updated by treeps  */
	lnode  	     *active_user_list;  /* Current active user_id's     */
	lnode        *active_group_list; /* Currently active group_ids   */
	lnode        *group_login_list;  /* Current groups logged in     */
	lnode        *user_login_list;   /* Current users logged in      */
	tnode	     *head;		 /* User group tree 		 */

	int	      num_grp_selected;	 /* Number of grp nodes selected */

	tnode	     *no_group;		 /* Points to orphan psuedo group */

	int	     info_loaded;

	Widget	      ug_shell;
	Widget	      form_w;
	Widget	      parent_w;
	Widget	      tree_w;
	uid_t	      user_uid;		 
	gid_t	      user_gid;

	char	     *user_uid_str;
	char	     *user_gid_str;
	Group_info   *group_info;
	Passwd_info  *passwd_info;
	void	      (*process_cb)();
	void	      (*popdownCB)();
} User_group_info;


extern User_group_info *setup_user_group();

extern char *find_name_by_gid();
extern char *find_name_by_uid();

