/* File: 	security.h
 *
 * Description: Include file for default security settings
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1999, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	5/16/99	Created
 *
 */

#ifndef SECURITYH
#define SECURITYH

/* If the following are set to 1 AND the program is setuid to root, then the
 * feature is enabled by default. This can be overriden at run time by
 * the run time security system. See security.c
 */

#define TRUSTED_USER                            0  /* Can signal any process */

#define TRUST_DECREASE_OWN_NICE_VALUE           0

#define TRUST_CHANGE_ANY_PROCESS_NICE_VALUE     0


#endif /* SECURITYH */
