/* File: 	machine_info.h
 *
 * Description: Include file for machine info structure
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2002, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	01/12/2002	Created
 *
 */

#ifndef MACHINE_INFOH
#define MACHINE_INFOH

#define INTERNAL_POLL_SCANNER		0
#define EXTERNAL_POLL_SCANNER		1
#define NOTIFICATION_SCANNER		2   /* always external */

typedef struct _varbind {
   char	*name;
   char *value;
} VarBind;

typedef VarBind *VarList;

/* -------------------- Per Machine Structure ------------------------ */

typedef struct _machine_info
{
	char	*name;		/* hostname */
	char	*osType;
	char	*osRelease;

	int	scanner_type;

	int	(*get_machine_status) ();

	int	(*get_first_pid) ();
	int	(*get_next_pid) ();
	int	(*close_pid_scanner) ();

	int	(*cache_process_details) ();
	int	(*get_pid_main_details) ();
	int	(*get_pid_extra_details) ();
	int	(*release_process_details) ();

	int	(*cleanup_pid_scanner) ();

	void	*data;	        /* private data for the interface code */

	struct  _machine_info  *next;
} Machine_info;

#endif /* MACHINE_INFOH */
