/* File: 	help.c
 *
 * Description: Routines to provide various help functions
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	4/14/95 Copied from menu_bar.c
 *
 */

#include <sys/types.h>
#include <unistd.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/SeparatoG.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

#include "libXs.h"

#include "config.h"

#include "debug.h"

void 		do_sendmail();
void 		do_mailaddr();

void 		do_popdown();


XmString	Treeps_help     = NULL;
static char    *Treeps_help_str[] = {
"                       Treeps - Version 1.2.2",
"",
" Treeps dynamically display's process information in a color coded tree",
" diagram. This makes it very easy to see what programs are running on your",
" computer and what they are doing. Programs running with your user id are",
" color coded using your individual colors or those of your group if you have",
" not assigned any. Programs running under other user id's, such as root are",
" displayed with different color combinations. By default procees are color",
" coded by effective user id. This makes it very easy to see which, if any,",
" of the programs you are running have special privileges. ",
" ",
" A user/group tree display can be used to display the relationships of",
" users and group. It also provides an easy way to select which users",
" processes you wish to view. Processes can also be color coded by various ",
" other values, such as cpu load, memory usage, group id, ...",
"",
" Detailed process information may be displayed by selecting a process",
" in the main tree. This displays most of the essential process data fields.",
" On some systems you can drill farther down to see even more details such",
" as open files, linked libraries, LWP info ... Fields from a process",
" details dialog may be extracted up into the tree display by selecting",
" it's label. Field values can be toggled between numeric and text.",
" ",
" Process decorations make it very easy to see which programs are ",
" actually doing something. Flashing LED indicators pop up and flash when",
" processes are using the cpu or changing state. These LED's also stick",
" around for a while afterwards so you can easily see which processes were",
" doing something in the last minute or so.",
"",
" A number of actions may be performed on processes, such as viewing",
" it's man page, killing it, sending it a signal, tracing it ...",
" A mechanism also exist for you to perform custom actions via shell",
" scripts.",
"",
" For more information, right click on the treeps process in the tree",
" diagram and select the man page menu option.",
"",
"           Author - George (Don't shake my Tree) MacDonald",
};

XmString	Treeps_cpr_help     = NULL;
static char    *Treeps_cpr_help_str[] = {
"",
"       Copyright (c) 1995,1996,1998,1999,2001 Pulsar Software Inc.",
"           All Rights Reserved, Unpublished rights reserved.",
"                  Disclaimer: See the Copyrights file",
"           For more information please read the manual page.",
"             Comments, suggestions, to gmd@orbit2orbit.com",
"",
" Some source(and much enlightenment) derived from:",
"",
"        The X Window System,",
"        Programming and Applications with Xt",
"        OSF/Motif Edition",
" by",
"        Douglas Young",
"        Prentice Hall, 1990",
"",
"        Copyright 1989 by Prentice Hall, All Rights Reserved",
};

XmString     Treeps_menu_bar_help = NULL;
static char *Treeps_menu_bar_help_str[] = {
"                  Treeps Menu Bar Help",
"",
" Program      - The program menu has four entries which control",
"                various aspects of program execution. In particular",
"                the data gathering engine can be halted/run as desired.",
"",
" Views        - The view menu provides control over the visual",
"                properties of the process tree as a whole. It also",
"                provides access to other control panels/dialogs.",
"",
" Users        - The user menu provides quick selection of the",
"                most frequently viewed sets of user processes. It",
"                also provides access to the user/group viewer.",
"",
" Processes    - The processes menu sets the current colorization",
"                technique, selection action and signal. It also",
"                can be used to turn on/off process decorations as",
"                well as specifuing whether or not daemon processes",
"                are displayed.",
"",
" Help         - The help menu provides some basic help and info",
"                about the program. A submenu can be used to display",
"                a number of relevant man pages.",
"",
};

XmString     Treeps_popups_help = NULL;
static char *Treeps_popups_help_str[] = {
"                  Treeps Popup Menu Help",
"",
" Two popup menus are provided, one for the tree diagram as",
" a whole, and one for each process displayed in the tree.",
"",
" The popup menus are invoked by pressing the menu button(typically",
" the right most mouse button) or the menu key(typically F4) while",
" over an area of interest.",
"",
" The tree popup menu provides two actions which operate on the",
" whole tree. The first, Show All Hidden Processes, makes all hidden ",
" processes visible. The second, Toggle tree outline, displays",
" the whole tree in either outline/or normal format.",
"",
" The process menu popup allows you to invoke a single action",
" on the specified process.",
};

XmString     Treeps_keys_help = NULL;
static char *Treeps_keys_help_str[] = {
"                  Treeps Keyboard Function Map",
"",
"The following keys can be used as shortcuts when the mouse is not",
"over one of the processes in the tree.",
"",
"l - Left to Right Orientation        + - Increase Tree Padding",
"r - Right to Left Orientation        - - Decrease Tree Padding",
"t - Top to Bottom Orientation        o - Toggle Tree Outline",
"b - Bottom to Top Orientation        h - Show any Hidden Processes",
"s - Star Topology                    q - Toggle Process Decorations",
"                                     ",
"e - Tier Connection style            a - Show All Processes",
"d - Diagonal Connections             u - Show Users Processes",
"p - Pathway Connections              ",
"n - No Connections                   f - Show Find Dialog",
"",
};
	
XmString     Treeps_button_help = NULL;
static char *Treeps_button_help_str[] = {
"                  Treeps Button Bar Icons",
"",
"  The button bar consists of a number of groups of icons which",
" provide quick access to the most frequently used functions.",
" The buttons are from left to right:",
"",
"    Halt/Run   -  This toggles the data gathering engine on/off",
"                  When running(indented) the program gathers data",
"                  and updates the display. Halting the data gathering",
"                  allows one to capture a particular tree or reduce",
"                  the programs load on the system.",
"",
"    Group/User      -  Toggles display of the User/Group tree dialog.",
"    Color Map       -  Toggles display of the color map dialog.",
"    Field Selector  -  Toggles display of the field selector dialog.",
"",
"    Login user -  Selects the login users processes.",
"    All users  -  Selects all users processes.",
"    Super user -  Selects root processes.",
"    User/Group -  Tree uses the group/users window selection criteria.",
"",
"    UID Color  -  Color code by real user id.",
"    EUID Color -  Color code by effective user id.",
"",
"    Daemons/Foreground  - Toggles between displaying or not",
"                          displaying daemons(processes with",
"                          no controlling terminal).",
"",
"    Select       -  Selection action selects a node. The process",
"                    name can then be pasted into another window.",
"    Information  -  Selection action causes details to popup.",
"    Signal       -  Selection action sends current signal to process",
"    Kill         -  Selection action kills process(signal 9)",
"",
"    Last Placement   -  Parent node is placed above last child",
"    Center Placement -  Parent node is centered on children",
"",
"    Decorations      -  Process decorations are toggled on/off",
"",
" Button states reflect current menu setting's and vice versa.",
};

XmString     Treeps_timer_help = NULL;
static char *Treeps_timer_help_str[] = {
"                      Timer Controls Help",
"",
" Every SHORT TIC the program checks for new/exiting processes,",
" if a new process is found it is added to the active list and if",
" it matches the current display criteria it is displayed. If their",
" were no new or exiting processes then the program scan's the ",
" active list and updates the display with any changed values.",
"",
" If the time allowed for a short tic is set too low, treeps will",
" sample at a high rate and cpu usage will increase significantly.",
" If the short tic duration is set too high, then treeps will miss short",
" duration processes. A value of about 1000 milliseconds (1 second)",
" is probably reasonable, perhaps less if you have a fast machine and",
" have cpu cycles to spare. Also your X window setup will have an",
" impact. If you are on a busy system and have a slow X Server you",
" may wish to increase the short tic duration to stop update thrashing.",
" ",
"",
" Every LONG TIC all process information is updated and any screen",
" updates are made. This includes all dynamic variables ",
" as well as the color coding and counts in the color bar.",
" A long tick is measured in n short ticks, typically about 10 short",
" ticks. If a process is on the active list and has had no state",
" changes in the last two long ticks it is removed from the active",
" list, unless it's locked in the active list. See the Update on:",
" option menu on the Display List popup or the Update panel on the",
" Process Details popup.",
"",
};

XmString     Treeps_user_group_help = NULL;
static char *Treeps_user_group_help_str[] = {
"                   Group User Tree Dialog Help",
"",
"  The Group/User Tree provides the ability to view the ",
"  ",
"      Currently active user/group id's",
" ",
"      Logged in user(s)/group(s)",
" ",
"      Background user/group id's ",
" ",
"      Various Group/user relationships",
" ",
" and to select users for display in the tree.",
" ",
" Selecting a user node marks it with a '*' and adds it",
" to the list of user id's that form the group/user tree",
" display criteria. If it's already selected then selecting",
" it again removes it from the display criteria. The main",
" process tree display is immediately updated to reflect new",
" display criteria. The group/user display criteria is saved",
" when a different selection is made from the menu/button bar.",
" Thus one can return to the group/user criteria by selecting",
" the GU button or Users->User/Group menu item again.",
"",
};

XmString     Treeps_decoration_help = NULL;
static char *Treeps_decoration_help_str[] = {
"                   Process Decoration Help",
"",
" When decorations are enabled distinguished processes are decorated",
" in the main tree display. There are two kinds of decorations.",
" ",
"     Leader Bars - displayed to the left of process label.",
" ",
"         Session Leader       - Two vertical lines",
" ",
"         Process Group Leader - One vertical line",
" ",
"     Activity Indicators - displayed above the process label,",
"                           these are from left to right",
" ",
"         State    - Displays the process state color",
" ",
"         Load     - Displays current load color",
" ",
"         Priority - Displays current priority color",
" ",
" Activity indicators are updated every short tic(default 1 sec).",
" If there is no distinguishing activity(load/state change) on",
" a process for a specified amount of time(fame_time) then the",
" activity indicators are retired(removed from display). The",
" default fame_time(set in the X resource file) is 20, which ",
" is about 1 minute. Thus any decorated process with activity",
" indicators has done something in the last minute.",
" ",
" ",
" The decoration backgrounds are filled in the following manner:",
" ",
"     Leader Bar Background = Real Group ID Color",
"",
"     Activity Background   = Real User ID Color",
"",
"",
};

XmString     Treeps_details_help = NULL;
static char *Treeps_details_help_str[] = {
"                   Process Details Popup Help",
"",
" The detail popup provides access to all of the process information",
" that treeps has gathered for the selected process. Each field is",
" displayed with a label and a value. The labels are selectable",
" and when a field is selected it is added to the information",
" displayed for the process in the tree diagram. ",
"",
" Field descriptions:",
"",
"      Image size and Memory resident are measured in pages, ",
"      typically 4k in size.",
" ",
" Some of the fields contain numeric values that are sometimes more ",
" readily understood when replaced by their textual counterparts.",
" The Text/Numeric button toggles between the two.",
"",
" The rate at which the detailed information is updated is ",
" controlled by the update rate panel near the bottom of the ",
" popup.",
"",
" A platform specific panel provides access to more details,",
" e.g. on GNU/Linux the open fds, environment and memory dialogs",
" can be poped up.",
};

XmString     Treeps_display_list_help = NULL;
static char *Treeps_display_list_help_str[] = {
"                   Display List Popup Help",
"",
" The display list popup provides a quick way of selecting ",
" which fields of information are to be displayed in the process",
" tree diagram. A field is selected by pressing the mouse button",
" when the cursor is over the field label. When selected a brief",
" description of the field is displayed in the comment area and",
" the tree diagram is immediatly updated to display the field",
" selected. Information for individual processes can be selected",
" from the process details popup.",
"",
" The rate at which process tree details are updated is controlled",
" by the Update On: option menu, and can be either on a short or ",
" long tic. See the Timer Control Panel for current tic settings.",
"",
};

XmString     Treeps_star_layout_help = NULL;
static char *Treeps_star_layout_help_str[] = {
"                   Star Layout Tips",
"",
"The star layout is experimental code and should only be used",
"after you have some experience with the program.",
" ",
"The algorithm used is not very efficient and there is a bug",
"that can cause many rapid window updates. This can cause treeps",
"to be very unresponsive for long periods of time. Use caution",
"when selecting this option. Don't select the process",
"decorations or change user display criteria when using",
"star topology. Instead make these selections before enabling",
"this layout. You may also want to halt the data gathering",
"on busy systems while viewing star topology.",
"",
"If this is your first time using the program stick with the",
"left to right layout until you get the hang of it.",
"",
};


XmString     Treeps_find_help = NULL;
static char *Treeps_find_help_str[] = {
"                     Finding a Process",
"",
"Entering a process name or pid followed by the return key will",
"kick off a search for a matching process. The visible tree is",
"scanned and if a match is found that node is selected and it's",
"colors changes to reflect the fact. The process name is then placed",
"in the selection buffer and can be pasted into another window.",
"",
"A search may be continued by pressing the enter key again or",
"by selecting the search button.",
"",
"Note: If you leave the mouse pointer within the find dialog area",
"then each matched process has it's process tip popup automatically.",
"as it's selected.",
"",
"PLEASE REMEMBER THAT ONLY VISIBLE PROCESSES ARE SEARCHED!!!!",
"",
};


static char *Quest_address="gmd@orbit2orbit.com";
static char *Quest_str="\n \
If you are connected to the internet the supplied address should work, if \n \
not put whatever your system needs to get to the internet in front of the \n \
address. Just remove this stuff and replace it with your question.\n \
\n \
Press Send then Cancel to close the dialog\n \
";

static char *Register_address="gmd@orbit2orbit.com";
static char *Register_str="\n \
If you are interested in joining a mailing list about this program \n \
please send off this mail to the above address. If you are connected to the\n \
internet the supplied address should work, if not put whatever your system\n \
needs to get to the internet in front of the address. The list will be very \n \
low bandwidth, perhaps just update information, bugs ... If your mailer \n \
puts a proper return address in From field of the mail header, just press \n \
the send key and that's all there is to it. If it doesn't or you want the \n \
mail to go somewhere else then put the address after the ADDR: on the \n \
line below. \n \
\n \
Note: Press Send then Cancel to close the dialog\n \
\n \
ADDR: ";


Widget Mail_addr_w=NULL;

extern Widget create_label();

extern Debug;


void 
show_help( w, topic )
Widget w;
char  *topic;
{
	DEBUG1( 1, "show_help: topic(%s)\n", topic);

	if ( strcmp( topic, "about" ) == 0 )
	{
		if ( Treeps_help == NULL )
			Treeps_help = xs_str_array_to_xmstr( Treeps_help_str, 
						XtNumber( Treeps_help_str ) );
		display_help_popup( w, Treeps_help );
	}
	else if ( strcmp( topic, "menu_bar" ) == 0 )
	{
		if ( Treeps_menu_bar_help == NULL )
			Treeps_menu_bar_help = 
			      xs_str_array_to_xmstr( Treeps_menu_bar_help_str, 
					XtNumber( Treeps_menu_bar_help_str ) );
		display_help_popup( w, Treeps_menu_bar_help );
	}
	else if ( strcmp( topic, "popups" ) == 0 )
	{
		if ( Treeps_popups_help == NULL )
			Treeps_popups_help = 
				xs_str_array_to_xmstr( Treeps_popups_help_str, 
					XtNumber( Treeps_popups_help_str ) );
		display_help_popup( w, Treeps_popups_help );
	}
	else if ( strcmp( topic, "keys" ) == 0 )
	{
		if ( Treeps_keys_help == NULL )
		   Treeps_keys_help=xs_str_array_to_xmstr(Treeps_keys_help_str,
					XtNumber( Treeps_keys_help_str ) );
		display_help_popup( w, Treeps_keys_help );
	}
	else if ( strcmp( topic, "buttons" ) == 0 )
	{
		if ( Treeps_button_help == NULL )
		{
		      Treeps_button_help = 
				xs_str_array_to_xmstr(Treeps_button_help_str,
				XtNumber( Treeps_button_help_str ) );
		}

		display_help_popup( w, Treeps_button_help );
	}
	else if ( strcmp( topic, "user_group" ) == 0 )
	{
		if ( Treeps_user_group_help == NULL )
			Treeps_user_group_help = 
			    xs_str_array_to_xmstr( Treeps_user_group_help_str, 
				XtNumber( Treeps_user_group_help_str ) );
		display_help_popup( w, Treeps_user_group_help );
	}
	else if ( strcmp( topic, "timer" ) == 0 )
	{
		if ( Treeps_timer_help == NULL )
		{
			Treeps_timer_help = 
				xs_str_array_to_xmstr( Treeps_timer_help_str, 
				XtNumber( Treeps_timer_help_str ) );
		}

		display_help_popup( w, Treeps_timer_help );
	}
	else if ( strcmp( topic, "find" ) == 0 )
	{
		if ( Treeps_find_help == NULL )
		{
			Treeps_find_help = 
				xs_str_array_to_xmstr( Treeps_find_help_str, 
				XtNumber( Treeps_find_help_str ) );
		}

		display_help_popup( w, Treeps_find_help );
	}
	else if ( strcmp( topic, "decorations" ) == 0 )
	{
		if ( Treeps_decoration_help == NULL )
		{
		      Treeps_decoration_help = 
			xs_str_array_to_xmstr(Treeps_decoration_help_str,
				   XtNumber( Treeps_decoration_help_str ) );
		}

		display_help_popup( w, Treeps_decoration_help );
	}
	else if ( strcmp( topic, "display_list" ) == 0 )
	{
		if ( Treeps_display_list_help == NULL )
		{
		      Treeps_display_list_help = 
			xs_str_array_to_xmstr(Treeps_display_list_help_str,
				   XtNumber( Treeps_display_list_help_str ) );
		}

		display_help_popup( w, Treeps_display_list_help );
	}
	else if ( strcmp( topic, "star_layout" ) == 0 )
	{
		if ( Treeps_star_layout_help == NULL )
		{
		      Treeps_star_layout_help = 
			xs_str_array_to_xmstr(Treeps_star_layout_help_str,
				   XtNumber( Treeps_star_layout_help_str ) );
		}

		display_help_popup( w, Treeps_star_layout_help );
	}
	else if ( strcmp( topic, "details" ) == 0 )
	{
		if ( Treeps_details_help == NULL )
		{
		      Treeps_details_help = 
				xs_str_array_to_xmstr(Treeps_details_help_str,
				XtNumber( Treeps_details_help_str ) );
		}

		display_help_popup( w, Treeps_details_help );
	}
	else if ( strcmp( topic, "copyrights" ) == 0 )
	{
		if ( Treeps_cpr_help == NULL )
		{
		      Treeps_cpr_help = 
				xs_str_array_to_xmstr(Treeps_cpr_help_str,
				XtNumber( Treeps_cpr_help_str ) );
		}

		display_help_popup( w, Treeps_cpr_help );
	}
	else if ( strcmp( topic, "ask" ) == 0 )
	{
		display_mail_popup( w, Quest_str, Quest_address );
	}
	else if ( strcmp( topic, "register" ) == 0 )
	{
		display_mail_popup( w, Register_str, Register_address );
	}
}

display_mail_popup( parent, mail_template_str, address )
Widget parent;
char *mail_template_str;
char *address;
{
	static 		Widget mail_pw=NULL;
	static		Widget addr_w=NULL;
	static		Widget body_w=NULL;
	Widget 		label_w, sep1, sep2, send_w, cancel_w;
	XmString	title_str;
	int    		n;
	Arg    		wargs[14];

	if ( mail_pw == NULL )
	{
	    title_str = XmStringCreate("Treeps: Mailer",
						XmSTRING_DEFAULT_CHARSET);
	    n = 0;
	    XtSetArg( wargs[n], XmNdialogTitle,   title_str ); n++;
 	    XtSetArg( wargs[n], XmNautoUnmanage, FALSE ); n++;
            XtSetArg( wargs[n], XmNfractionBase, 10 ); n++;
	    mail_pw = XmCreateFormDialog( parent,"Treeps: Help",wargs,n);
	    if ( mail_pw == NULL )
	    {
		DEBUG1(1, "display_mail_popup: Failed parent(%d)\n",parent);
		return;
	    }

	    /* Create one line editable text widget at top with address */

            label_w = create_label("To:", mail_pw, NULL, NULL);

	    n = 0;
 	    XtSetArg( wargs[n], XmNeditable, TRUE); n++;
 	    XtSetArg( wargs[n], XmNtraversalOn, TRUE); n++;
	    XtSetArg( wargs[n], XmNcursorPositionVisible, TRUE); n++;
	    XtSetArg( wargs[n], XmNhighlightThickness, 1); n++;
	    XtSetArg( wargs[n], XmNcolumns, 40); n++;
 	    XtSetArg( wargs[n], XmNmarginHeight, 1); n++;
            XtSetArg( wargs[n], XmNmarginWidth, 3); n++;
            XtSetArg( wargs[n], XmNshadowThickness, 1); n++;
            addr_w = XtCreateWidget( "mail_address", xmTextWidgetClass,
                                                mail_pw, wargs, n );

 	    XtAddCallback( addr_w, XmNactivateCallback, do_mailaddr, 
								"mail_address");

            align_attach_manage( NULL, 1, label_w, addr_w );

	    Mail_addr_w = addr_w;

	    /* Create separator */

 	    n = 0;
            XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
            XtSetArg( wargs[n], XmNtopOffset, 2); n++;
            XtSetArg( wargs[n], XmNtopWidget, addr_w); n++;
            sep1 = XtCreateManagedWidget( "mail_separator1", 
						xmSeparatorGadgetClass,
                                                mail_pw, wargs, n );
	    
	    /* Create send, cancel buttons at bottom */

            n = 0;
            XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
            XtSetArg( wargs[n], XmNleftPosition, 1); n++;
            XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
            XtSetArg( wargs[n], XmNrightPosition, 4); n++;
            XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
            send_w = XtCreateManagedWidget("Send", xmPushButtonWidgetClass,
                                                mail_pw, wargs, n );

            n = 0;
            XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
            XtSetArg( wargs[n], XmNleftPosition, 6); n++;
            XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
            XtSetArg( wargs[n], XmNrightPosition, 9); n++;
            XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
            cancel_w = XtCreateManagedWidget("Cancel", xmPushButtonWidgetClass,
                                                mail_pw, wargs, n );

	    XtAddCallback( cancel_w, XmNactivateCallback, do_popdown, mail_pw);

	    /* Create bottom seperator */

 	    n = 0;
            XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
            XtSetArg( wargs[n], XmNbottomWidget, send_w); n++;
            sep2 = XtCreateManagedWidget( "mail_separator2", 
						xmSeparatorGadgetClass,
                                                mail_pw, wargs, n );

	    /* Create text edit widget */
            n = 0;
            XtSetArg( wargs[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
            XtSetArg( wargs[n], XmNrows, 16 ); n++;
            XtSetArg( wargs[n], XmNcolumns, 80 ); n++;
            XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
            XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
            XtSetArg( wargs[n], XmNbottomWidget, sep2); n++;
            XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
            XtSetArg( wargs[n], XmNtopWidget, sep1); n++;
            body_w = XtCreateManagedWidget( "mail_body", xmTextWidgetClass,
                                                mail_pw, wargs, n);

	    XtAddCallback( send_w, XmNactivateCallback, do_sendmail, body_w);
	}

	/* Display address */

	XmTextSetString( addr_w, address );

	/* Display mail_template_str */

	XmTextSetString( body_w, mail_template_str );

	XtManageChild( mail_pw );
}

void
do_sendmail( w, body_w, call_data)
Widget w;
Widget body_w;
caddr_t call_data;
{
	char *addr;
	char *body;
	char cmd[80];
	FILE *fp;
	

	addr = XmTextGetString( Mail_addr_w );
	body = XmTextGetString( body_w );

	sprintf( cmd, "%s %s", MAILER, addr );

	fp = popen( cmd, "w" );
	if ( fp == NULL )
	{
		user_alert( w, "Command to send mail failed\n" );
		return;
	}

	fputs( body, fp );

	pclose( fp );
}

void
do_mailaddr( w, pw, call_data)
Widget w;
Widget pw;
caddr_t call_data;
{

	/* A new address, ignore, get contents of text widget when we send it */
}

display_help_popup( parent, help_str )
Widget parent;
XmString help_str;
{
	static 		Widget help_pw=NULL;
	Widget 		exit_w, help_w;
	XmString	title_str, exit_str, message_str;
	XmString	info_str;
	int    		n;
	Arg    		wargs[8];

	if ( help_pw == NULL )
	{
	    /* XtSetArg( wargs[n], XmNdialogType, XmDIALOG_MESSAGE ); n++; */
	    title_str = XmStringCreate("Treeps: Help",XmSTRING_DEFAULT_CHARSET);
	    exit_str  = XmStringCreate("Done", XmSTRING_DEFAULT_CHARSET );

	    message_str = XmStringCreate( "Help", XmSTRING_DEFAULT_CHARSET );

	    n = 0;
	    XtSetArg( wargs[n], XmNdialogTitle,   title_str ); n++;
	    XtSetArg( wargs[n], XmNokLabelString, exit_str ); n++;
	    XtSetArg( wargs[n], XmNmessageString, message_str ); n++;
	    XtSetArg( wargs[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON ); n++;
#ifdef LESSTIF
	    XtSetArg( wargs[n], XmNsymbolPixmap, XmUNSPECIFIED_PIXMAP ); n++;
#else
	    XtSetArg( wargs[n], XmNsymbolPixmap, NULL ); n++;
#endif
	    help_pw = XmCreateInformationDialog( parent,"Treeps: Help",wargs,n);
	    if ( help_pw == NULL )
	    {
		DEBUG1(1, "display_help_popup: Failed parent(%d)\n",parent);
		return;
	    }
	    
	    exit_w   = XmMessageBoxGetChild( help_pw, XmDIALOG_OK_BUTTON );
	    XtAddCallback( exit_w, XmNactivateCallback, do_popdown, help_pw);

	    XtUnmanageChild( XmMessageBoxGetChild( help_pw, 
						     XmDIALOG_HELP_BUTTON ));
	    XtUnmanageChild( XmMessageBoxGetChild( help_pw, 
						     XmDIALOG_CANCEL_BUTTON));
	}
	/* Display help_str */

	n = 0;
	XtSetArg( wargs[n], XmNmessageString, help_str ); n++;
	XtSetValues( help_pw, wargs, n );

	XtManageChild( help_pw );
}

user_alert( parent, alert_str )
Widget parent;
char  *alert_str;
{
	static 		Widget alert_pw=NULL;
	Widget 		exit_w, help_w;
	XmString	title_str, exit_str, message_str;
	XmString	info_str;
	int    		n;
	Arg    		wargs[8];

	if ( alert_pw == NULL )
	{
	    title_str = XmStringCreate("Alert:", XmSTRING_DEFAULT_CHARSET );
	    exit_str  = XmStringCreate("Dismiss", XmSTRING_DEFAULT_CHARSET );

	    message_str = XmStringCreate(
			"Well here is the alert, not much eh?", 
			XmSTRING_DEFAULT_CHARSET );

	    n = 0;
	    XtSetArg( wargs[n], XmNdialogTitle,   title_str ); n++;
	    XtSetArg( wargs[n], XmNokLabelString, exit_str ); n++;
	    XtSetArg( wargs[n], XmNmessageString, message_str ); n++;
	    XtSetArg( wargs[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON ); n++;
	    alert_pw = XmCreateErrorDialog( parent, "Alert", wargs,n);
	    if ( alert_pw == NULL )
	    {
		DEBUG1(1, "display_alert_popup: Failed parent(%d)\n",parent);
		return;
	    }
	    
	    exit_w   = XmMessageBoxGetChild( alert_pw, XmDIALOG_OK_BUTTON );
	    XtAddCallback(exit_w, XmNactivateCallback, do_popdown, alert_pw);

	    XtUnmanageChild( XmMessageBoxGetChild( alert_pw, 
						     XmDIALOG_HELP_BUTTON ));
	    XtUnmanageChild( XmMessageBoxGetChild( alert_pw, 
						     XmDIALOG_CANCEL_BUTTON));
	}
	message_str = XmStringCreate( alert_str, XmSTRING_DEFAULT_CHARSET );

	n = 0;
	XtSetArg( wargs[n], XmNmessageString, message_str ); n++;
	XtSetValues( alert_pw, wargs, n );

	XtManageChild( alert_pw );
}

void
do_popdown( w, pw, call_data)
Widget w;
Widget pw;
caddr_t call_data;
{
	XtUnmanageChild( pw );
}
