/* File: 	treeps.h
 *
 * Description: Include file for global defs and structures
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1993, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *
 */

#ifndef TREEPSH
#define TREEPSH

#ifndef CONFIGH
#include "config.h"
#endif

#ifndef MACHINE_INFOH
#include "machine_info.h"
#endif

#define CHILD_ATTACH	0
#define GROUP_ATTACH	1
#define SMART_ATTACH	2


/* A structure to hold application data, ie app setting's from X resources  */

typedef struct {
	int	debug_level;
	int	short_tic;		/* Update rate in millesecs's       */
	int	long_tic;		/* Data/screen refresh rate 	    */
	int	shrink_delay;		/* Number of refresh cycles before  */
	int	outlineWidth;		/* Size of outlined node	    */
	int	outlineHeight;	
	Boolean menu_bar;		/* When set show menu bar  	    */
	Boolean button_bar;		/* When set show button bar 	    */
	Boolean disp_pid;		/* When set display pid             */
	Boolean disp_pname;		/* When set display process name    */
	Boolean show_all;		/* When set display all processes   */
	Boolean show_process_groups;	/* Deprecate */
	int     process_attach_mode;	/* Type of attachment used          */
	Boolean show_daemons;		/* When set background processes shown*/
	Pixel   node_foreground;	/* Default process node fg color    */
	Pixel	node_background;	/* Default process node bg color    */
	Pixel   selected_node_foreground;/* fg color when node selected     */
	Pixel	selected_node_background;/* bg color when node selected     */
	char   *color_based_on;		/* user_id, load, recent_activity ..*/
	char   *users_color_list;	/* Username, fg, background colors  */
	char   *groups_color_list;	/* Group, fg, background colors     */
	char   *stats_color_list;	/* Statistical colors, fg, bg       */
	char   *load_color_map;		/* CPU load color map,              */
	char   *tcpu_color_map;		/* Total CPU time color map,        */
	char   *status_color_map;	/* Status CPU time color map,       */
	char   *image_color_map;	/* Image color map,                 */
	char   *priority_color_map;	/* Priority color map,              */
	char   *resident_color_map;	/* Resident pages  color map,       */
	char   *treepsLibRoot;		/* Root dir of treeps system files  */
	char   *treepsUserRoot;		/* Root dir of user related files   */
	int	showProcessTips;	/* Whether or not to use node tips  */
	char	*processTipFont;
	Pixel	processTipBackground;
	Pixel   processTipForeground;
	int	buttonBarIconSize;	/* 16/24/32/64			    */
	char	*buttonBarIconDepth;	/* mono/loColor/hiColor             */
	char	*buttonBarIconDir;	/* Dir name, usually "icons"        */
	int     decorate_tree;	/* DECORATE_NONE, _ALL, _DISTINGUISHED */
	int     fame_time;	/* # of samples to stay distinguished       */
	char   *systemMap;	/* Symbol table for kernel 		    */
	Boolean virtualDesktop;	/* set when you use a virtual desktop 	    */
	Boolean autoSizeMainWindow;
	Boolean fitToScreen;	/* Main window will try to fit on screen    */
	int	rightOffset;	/* Amount reserved on right of screen       */
	int	bottomOffset;   /* Amount of spece reserved on screen bottom*/
	Boolean displayLWP;	/* Display System 5.4 Light Weight Processes*/
	Boolean useExternalInterface; /* use generalized data gathering     */

} ApplicationData, *ApplicationDataPtr;




/* ----------------  Tree Node info description struct  ---------------- */

#define PR_PID  	 0
#define PR_FNAME	 1
#define PR_PSARGS	 2
#define PR_UID		 3
#define PR_GID		 4
#define PR_PPID		 5
#define PR_EUID		 6
#define PR_EGID		 7
#define PR_PGRP		 8
#define PR_SID		 9
#define PR_SNAME        10
#define PR_FLAGS	11
#define PR_NICE		12
#define PR_SIZE		13
#define PR_RSSIZE	14
#define PR_WCHAN	15
#define PR_START	16
#define PR_TIME		17
#define PR_PRI		18
#define PR_CLNAME	19
#define PR_TTYDEV	20
#ifdef SVR4_MP
#define PR_NLWP  	21
#define PR_ONPRO	22
#define PR_LAST		22
#else
#define PR_LAST		20
#endif

struct Node_Info_Description {
	int   field;
	char *short_name;
	char *description;
};

/* ---------------  Process Detail info widgets struct  ------------------- */

typedef struct Info_Widgets {
	Widget	name_w;
	Widget	pid_w;
	Widget	args_w;
	Widget	start_w;
	Widget	time_w;
	Widget	status_w;
	Widget	zombie_w;

	Widget	nice_w;
	Widget	flags_w;
	Widget	priority_w;
	Widget	old_priority_w; 	/* Reused as OnPro SVR4_MP */
	Widget	class_name_w;
	Widget	old_cpu_usage_w;	/* Reused as NoLWP SVR4_MP */

	Widget	uid_w;
	Widget	gid_w;
	Widget	euid_w;
	Widget	egid_w;
	Widget	ppid_w;
	Widget	group_leader_pid_w;
	Widget	session_id_w;
	Widget	controlling_tty_w;

	Widget	image_size_w;
	Widget	memory_resident_w;
	Widget	wait_addr_w;
} Node_info_widgets;


/* ----------------  Process statistics structure ------------------- */

typedef struct _stats {
	timestruc_t	last_time;	/* Processes usage on last interval */
	struct          timeval lastSampledAt;	/* Timestamp of last sample */
	double		last_load;	/* Used for decaying load avg       */
	double		current_load;
} Stats;

#define IGNORE_PROCESS  1
#define ADD_PROCESS     2
#define PROC_INFO_ERROR 0

/* ----------------  Process Tree Node Structure  ------------------- */

/* The following structure is replicated for each node of the displayed process 
 * tree, it contains a pointer to the system process info structure and a
 * pointer to the node display list and formating structure. It is passed
 * as opaque data to the generalized tree manipulation routines. It also
 * contains a pointer to a node in the Process_list. Only visible processes
 * have a tree node, the Process list has one for each process that can be
 * identified.
 */

/* State of each node in the tree */

#define NODE_EMPTY	0
#define NODE_DISPLAYED  1	
#define NODE_HIDDEN	2

/* State of each nodes dialog widget */

#define NO_DIALOG		0
#define DIALOG_DISPLAYED	1
#define DIALOG_HIDDEN		2

/* The mode of the detailed info popup */

#define NUMERIC_MODE		1
#define ALPHA_MODE		2

/* The update rate of the details popup dialog  */

#define UPDATE_ON_REQUEST	0	/* NOTE THESE MATCH BUTTON NUMBERS */
#define UPDATE_ON_SHORT_TIC	1	/* SO DO NOT CHANGE WITHOUT        */
#define UPDATE_ON_LONG_TIC	2	/* MODIFYING THE CODE              */

#define DECORATE_NONE           0
#define DECORATE_ALL            1
#define DECORATE_DISTINGUISHED  2

#define ATTACH_PARENT                   0
#define ATTACH_INIT                     1
#define ATTACH_GROUP_LEADER             2
#define ATTACH_SESSION_LEADER           3
#define ATTACH_DESKTOP_SESSION          4


typedef struct 	_process_tree_info {
	lnode			*l_ptr; /*Process_list node                */
	sysProcInfo		*pp;	/* points to list_info's copy      */
	lnode			*display_list; /* Displayed node values    */
	int			 display_update_rate; /* Short or Long Tic */
	Boolean			 outline;/* If set ignore display list     */
	Boolean			 selected;/* If selected for cut/paste     */
	Boolean			 processTipUp;   /* For dynamic updates    */
	int			 state; /* NODE_HIDDEN or NODE_DISPLAYED   */
	int                      attachType; /* Type of attachment used    */
	int			 uid;	/* cached for checking uid changes */
	Widget			 label_w; /* The label widget              */
	Widget			 node_w;  /* The node widget               */
	Widget			 top_draw_w; /* The top drawing area widget   */
	Widget			 left_draw_w; /* The left drawing area widget */
	int			 dialog_state; /* NO_DIALOG, DIALOG_DISPLAYED */
	Widget			 dialog_w; /* The dialog widget            */
	Node_info_widgets	 *dialog_info_widgets;
	int			 dialog_mode;  /* ALPHA_MODE, NUMERIC_MODE */
	int			 dialog_update_rate; /* Req, Short, Long Tic*/
	int			 distinguished; /* Can be decorated	   */
	int			 leader; /* Can have leader bars	   */
	Stats			 stats; /* Used if gathering process stats */
} Process_tree_info;


typedef struct _attach_point
{
        int             attachToPid;    /* pid attaching to, if negative ignore */
        timestruc_t     startTime;
} Attach_point;

typedef lnode *Attach_list;  /* List of processes that can attach to       */
typedef lnode *Death_list;   /* List of processes to notify on death       */

/* ---------------------  Process list variables  ------------------------ */

typedef struct _process_list_info {
	int		 euid;		/* From the stat call */
	int		 egid;		
	int		 active;	/* -1 locked in, 1-n long tic's    */
	sysProcInfo	*pp;		/* System process info structure   */
	tnode		*t_ptr;		/* Pointer to process tree node    */
        Attach_list     attachments;    /* list of places might attach to  */
        Death_list      notifyOnDeath;  /* list of processes for death notice */
        Boolean         hasWork;        /* this node is in a work list     */
} Process_list_info;

/* Some processes are attached to the tree in locations other than where
 * we want them to be. We call these relocated processes and we keep
 * them in a list so we can quickly find them and attach them in more
 * desirable locations.
 */

typedef struct _relocated_process
{
                        /* Process pid stored in list key */
        tnode   *node;  /* pointer to tree node */
} relocated_process;


/* The following is user to build a list of the login users controlling
 * terminals. This is sometimes used to determine if we can signal a process,
 * i.e. if the process has a different uid, but was started by the user(suid,
 * su ... ) then we allow the signal. 
 *
 */

typedef struct _user_tty_struct {
	dev_t		         ttydev;
	struct _user_tty_struct *next;
} User_tty_struct;


#define ACTION_PROCESS_SELECT		0
#define ACTION_PROCESS_SIGNAL		1
#define ACTION_KILL_PROCESS		2
#define ACTION_PROCESS_DETAILS		3
#define ACTION_OUTLINE_SUBTREE		4
#define ACTION_HIDE_SUBTREE		5
#define ACTION_SHOW_SUBTREE		6

#define FILTER_DESCENDANTS		1
#define SHOW_ALL_DESCENDANTS		2

extern int		Monitor_processes;
extern TreeOrientation	Current_orientation;
extern ConnectionStyle	Current_connection;
extern ParentPlacement	Current_placement;
extern int 		Show_process_groups;
extern int 		User_view;
extern int 		Group_view;
extern int 		Show_daemons;
extern int 		Show_all;
extern int 		Color_based_on;
extern int		Process_action;
extern int		Current_signal;
extern int		Show_descendants;

extern int 		Short_tic;
extern int 		Long_tic;

extern int 		Visible_processes_active;


extern int		Dynamic_colors;		/* Set when viewing stats */

extern Pixel		Node_foreground;
extern Pixel		Node_background;
extern Pixel		Selected_node_foreground;
extern Pixel		Selected_node_background;

extern int New_display_criteria;

extern Widget TreeWidget;
extern lnode  *Process_list;
extern tnode  *Head;

/* Some macro's to help trace the process list activities, note the 
 * semicolon from the initial statement is placed after the else during
 * the macro expansion. This ensures no side effects from placing before
 * else, while, for constructs.
 */

#ifdef PROC_TRACE
#define TRACE_LIST(label, list)	    if ( list ) print_list(label, list); else
#define DEBUG_LIST(label, list)	    if ( Debug > 0 && list ) print_list(label, list); else
#else
#define TRACE_LIST(label, list)	
#define DEBUG_LIST(label, list)	
#endif

#endif /* TREEPSH */
