/* File: 	config.h
 *
 * Description: This file contains #defines that are the most likely to
 *		be changed.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	 4/14/95 Created
 *		George MacDonald	10/27/98 Create platform specific file
 *		George MacDonald	11/20/02 Copy to IRIX64
 *
 */

#ifndef CONFIGH
#define CONFIGH


#include "localized.h"          /* Local locations, definitions, ... */
#include "security.h"           /* Include default security model */


#include <sys/procfs.h>

typedef prpsinfo_t        sysProcInfo;

/* Some macros to hide process info structure differences */

/* First the multi-threaded multi-processor version of SVR4 */

#define PROCESS_SNAME( pp )                     ( pp->pr_sname )
#define PROCESS_NICE( pp )                      ( pp->pr_nice )
#define PROCESS_FLAG( pp )                      ( pp->pr_flag )
#define PROCESS_USER_ID( pp )                   ( pp->pr_uid )
#define PROCESS_GROUP_ID( pp )                  ( pp->pr_gid )
#define PROCESS_ID( pp )                        ( pp->pr_pid )
#define PROCESS_PARENT_ID( pp )                 ( pp->pr_ppid )
#define PROCESS_GROUP_LEADER(pp)                ( pp->pr_pgrp )
#define PROCESS_SESSION_ID( pp )                ( pp->pr_sid )
#define PROCESS_ADDRESS( pp )                   ( pp->pr_addr )
#define PROCESS_SIZE( pp )                      ( pp->pr_size )
#define PROCESS_RESIDENT_SET_SIZE( pp )         ( pp->pr_rssize )
#define PROCESS_WCHAN( pp )                     ( pp->pr_wchan )
#define PROCESS_START_TIME( pp )                ( pp->pr_start )
#define PROCESS_CPU_TIME( pp )                  ( pp->pr_time )
#define PROCESS_PRIORITY( pp )                  ( pp->pr_pri )
#define PROCESS_OLD_PRIORITY( pp )              ( pp->pr_oldpri )
#define PROCESS_CPU( pp )                       ( pp->pr_cpu )
#define PROCESS_CONTROL_TTY( pp )               ( pp->pr_ttydev )
#define PROCESS_CLASS_NAME( pp )                ( pp->pr_clname )
#define PROCESS_CMD_NAME( pp )                  ( pp->pr_fname )
#define PROCESS_CMD_ARGS( pp )                  ( pp->pr_psargs )

#define PROCESS_EFFECTIVE_USER_ID( pli_ptr )    ( pli_ptr->euid )
#define PROCESS_EFFECTIVE_GROUP_ID( pli_ptr )   ( pli_ptr->egid )


#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif

#ifndef NULL_STR
#define NULL_STR	((char *) NULL)
#endif

#ifndef EMPTY_STR
#define EMPTY_STR	("")
#endif



#endif CONFIGH
