/* File: 	remove_tnode.c:  
 *
 * Description:	Remove a node from the tree using supplied pointer any
 *		children are orphaned to head of tree. The node is destroyed
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

tnode 
*remove_tnode( head, ptr )
tnode *head;
tnode *ptr;
{
	child_ptr  	*cptr;
	child_ptr  	*last_ptr;

	if ( ptr == NULL_TNODE_PTR || head == NULL_TNODE_PTR )
		return( ptr );

	if ( head == ptr )
	{
	    if ( ptr->children )
	    {
		(void) fprintf(stderr,"ERROR: Trying to remove head with children!\n");
		return( head );
	    }

	    head = NULL_TNODE_PTR; /* We fall through and let head be removed */
	}

	ptr = extract_tnode( ptr );

	/* Attach children to top node of tree */

	for ( cptr = ptr->children ; cptr != NULL ;  )
	{
		(void) add_tnode( head, cptr->child );

		last_ptr = cptr;
		cptr = cptr->next;

		free( last_ptr );
	}

	destroy_tnode( ptr );

	return( head );
}
