/* File: 	post_walk_tree.c:  
 *
 * Description:	Recursively walk the tree and apply the function to each
 *		node in the tree. Parents are processed after children.
 *		If the supplied function returns a non zero value, processing
 *		is stopped and the value is returned by walk_tree.
 *
 *		Note: No attempt is made to catch stack overflow's
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include "tree.h"
#include "debug.h"

tnode
*post_walk_tree( branch, func, arg )
tnode *branch;
tnode *(*func) ();
int arg;
{
	tnode 		*rc;
	child_ptr	*p, *nextp;

	if ( branch == NULL_TNODE_PTR )
		return( NULL_TNODE_PTR );

	for( p = branch->children ; p != NULL; p = nextp )
	{
		nextp = p->next;  /* In case child pointer  is removed */

		rc = post_walk_tree( p->child, func , arg);
		if ( rc != NULL_TNODE_PTR )
			return( rc );
	}

	/* After we have visited all the children, apply the function to
	 * this node.
	 */

	rc =  (*func) ( branch, arg );

	return( rc );
}

