/* File: 	next_name_after_key.c:  
 *
 * Description:	Function used by walk_tree to check if the supplied name
 *		matches the one in the supplied tnode pointer. It first finds
 *		a node that matches key, then continues search after that.
 *		This can be used to create a simple get_next mechanism.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	22/Nov/2001	Created
 *            
 * For efficiency we assume search_record is properly populated.
 *
 */

#include "tree.h"
#include "string.h"

tnode
*next_name_after_key( ptr, p )
tnode *ptr;
search_record *p;
{

	if ( ! p->found_key )
	{
	    if ( ptr->key == p->key )
	    	p->found_key++;
	}
	else
	{
	    if ( ptr->str_key && ( strcmp( ptr->str_key, p->name ) == 0) )
		return( ptr );
	}

	return( NULL_TNODE_PTR );
}

