/* File: 	move_tnode.c:  
 *
 * Description:	Move's the node from one part of a tree to another. All 
 *		children are moved too.
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include "tree.h"
#include "debug.h"

tnode
*move_tnode( from_node, to_node )
tnode *from_node;
tnode *to_node;
{
	if ( to_node == NULL_TNODE_PTR || from_node == NULL_TNODE_PTR )
		return( NULL_TNODE_PTR );

	/* Unlink from_node, from it's current position  */

	(void) extract_tnode( from_node );

	/* Now do a sorted insertion in the destination parent */

	(void) add_tnode( to_node, from_node );

	return( to_node );
}

