/* File: 	destroy_tnode.c:  
 *
 * Description:	Free up the space associated with the tnode
 *
 *		Note: this free's up the space pointed to by the data member
 *		but not any dynamically allocated space subtending the data
 *		member! If multiple nodes point to the same object, great
 *		care must be taken to avoid creating wild pointers.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

void
destroy_tnode( ptr )
tnode *ptr;
{
	if ( ptr->str_key != NULL )
		free( ptr->str_key );

	if ( ptr->data != NULL_TNODE_DATA_PTR )
		free( ptr->data );

	free( ptr );
}
