#ifndef		ONDEBUG
#define 	ONDEBUG

#include	<stdio.h>


/*
 * File:	debug.h 
 *
 * Description:	Simple Debug macro definitions which produce
 *		diagnostic output messages.
 *
 * Modifications:
 *	George MacDonald    8/09/89	Created
 *
 */


#ifndef	Debug			/* For those who like upper */
#define	Debug	debug		/* case global variables. */
#endif


#ifndef	NODEBUG

#define DEBUG0(lvl,fmt) \
	(void)( (debug >= lvl) ? fprintf(stderr,fmt) : 0 )

#define DEBUG1(lvl,fmt,a) \
	(void)( (debug >= lvl) ? fprintf(stderr,fmt,a) : 0 )

#define DEBUG2(lvl,fmt,a,b) \
	(void)( (debug >= lvl) ? fprintf(stderr,fmt,a,b) : 0 )

#define DEBUG3(lvl,fmt,a,b,c) \
	(void)( (debug >= lvl) ? fprintf(stderr,fmt,a,b,c) : 0 )

#define DEBUG4(lvl,fmt,a,b,c,d) \
	(void)( (debug >= lvl) ? fprintf(stderr,fmt,a,b,c,d) : 0 )

#define ENTER(a)\
	(void)( (debug >= 1) ? fprintf(stderr,"Entered->%s\n",a) : 0 )

#define LEAVE(a)\
	(void)( (debug >= 1) ? fprintf(stderr,"Leaving->%s\n",a) : 0 )

#else	/* NODEBUG */

#define	DEBUG0(lvl,fmt)
#define	DEBUG1(lvl,fmt,a)
#define	DEBUG2(lvl,fmt,a,b)
#define	DEBUG3(lvl,fmt,a,b,c)
#define	DEBUG4(lvl,fmt,a,b,c,d)
#define ENTER(a)
#define LEAVE(a)

#endif

#endif	
