/* File: 	construct_tnode.c:  
 *
 * Description:	Create space for a new tnode and populate with supplied data
 *
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/18/95	Created
 *            
 */

#include <stdlib.h>

#include "tree.h"
#include "debug.h"

extern char *strdup();

tnode
*construct_tnode( key, str_key, data )
int   key;
char *str_key;
void *data;	  /* Opaque data */
{
	tnode *ptr = ( tnode *) malloc(sizeof(tnode));

	if ( ptr == NULL_TNODE_PTR )
	{
		DEBUG0(0, "construct_tnode: malloc failed\n" );
		return( NULL_TNODE_PTR );
	}

	ptr->key 	= key;
	ptr->str_key 	= strdup(str_key);
	ptr->parent_key = 0;
	ptr->data    	= data;

	ptr->num_children = 0;
	ptr->children 	= NULL;
	ptr->parent 	= NULL_TNODE_PTR;

	return( ptr );
}
