/* File: 	child_pos.c:  
 *
 * Description:	Return child position of node
 *
 *		Positions range from 1 to n, and are contigous
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	4/21/95	Created
 *            
 */

#include "tree.h"
#include "debug.h"

int
child_pos( ptr )
tnode *ptr;
{
	tnode 		*p;
	child_ptr	*cptr;
	int		 pos=0;

	p = ptr->parent;
	if ( p == NULL_TNODE_PTR )
		return( -1 );

	for ( cptr = p->children ; cptr != NULL ; cptr = cptr->next )
	{
		if ( cptr->child == ptr )
			return( pos );
		pos++;
	}

	return( -1 );
}

