/* File: 	sysInfoLaunchPad.c
 *
 * Description: A very simple app to make it easy to browse various bits of system
 *		information. Just launches shell scripts and feeds output to a
 *		gui viewer.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 2001, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	11/19/2001	Created
 *            
 *
 */

#include <stdio.h>		
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <varargs.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef __linux__
#include <sys/mkdev.h>		/* To get major/minor numbers 		 */
#endif
#include <sys/param.h>		/* To get PAGESIZE i.e. system page	 */
#include <dirent.h>		/* To get the /proc directory listing	 */
#include <unistd.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>

#include "debug.h"	/* Macro based debug package		   */
#include "libXs.h"	

int Debug=0;

#ifdef __linux__
#define LINUX 1
#endif

typedef struct cmdEntry
{
  char *Category; 
  char *label; 
  char *shortCut;
  char *tooltip; 
  char *command; /* First char is P - pipe, G - gui, X - xterm, T - CmdTip, second char is space */
  char *viewer;  /* override default viewer */
} CommandEntry;


/* Currently tooltips are limited to commands with one line responses */

CommandEntry Commands[] = {
 { "OS", "Hostname",   "",    
 	"Display host name", "T hostname", 
		"textStreamViewer -tHostname -r1 -c40" },
 { NULL, "Info",   "",    
 	"Display OS, host name, release, version, architecture", "T uname -a", 
		"textStreamViewer -tOS_Info -r1 -c80" },
 { NULL, "Release",   "",    
 	"Display OS Release", "T uname -r", 
		"textStreamViewer -tOS_Release -r1 -c30" },
 { NULL, "Uptime", "U",    
 	"Amount of elapsed time since system started", "T uptime | sed 's/,  load.*$//'",
		"textStreamViewer -tSystem_Uptime -r1 -c40" },
 { NULL, "Vendor", "V",    
 	"Vendor of the OS", "T cat /etc/issue | sed -n -e '2p'",
		"textStreamViewer -tOS_Vendor -r1 -c60" },
#ifdef LINUX
 { NULL, "SysCtl", "",    
 	"Show Run Time settable Kernel Variables", "P /sbin/sysctl -a",
		"textStreamViewer -tSystemVariables -r40 -c80" },
 { NULL, "Lilo", "",    
 	"Show the lilo config File", "P cat /etc/lilo.conf",
		"textStreamViewer -t/etc/lilo.conf -r20 -c80" },
#else
 { NULL, "Boot", "",    
 	"Show the boot config file", "P cat /stand/boot",
		"textStreamViewer -t/stand/boot -r20 -c80" },
 { NULL, "sysdef", "Display System parameters",    
 	"", "P /usr/sbin/sysdef ",
		"textStreamViewer -tsysdef -r40 -c80" },
 { NULL, "PkgInfo", "",    
 	"Show list of installed Packages", "P pkginfo",
		"textStreamViewer -tPkgInfo -r40 -c120" },
 { NULL, "lp", "",    
 	"Produce printer status report", "P lpstat -s",
		"textStreamViewer -tlpstat -r20 -c80" },
 { NULL, "sar", "",    
 	"Produce sys activity report", "P sar",
		"textStreamViewer -tsar -r40 -c80" },

#endif
 { "", "Inittab",   "",    
 	"System initialization table", "P cat /etc/inittab", 
		"textStreamViewer -t/etc/inittab -r44 -c80" },
#ifdef LINUX
 { NULL, "modules", "",    
 	"Show the loaded modules", "P /sbin/lsmod",
		"textStreamViewer -tModules_Loaded -r20 -c80" },
 { NULL, "mod.conf", "",    
 	"Show the module config", "P cat /etc/*modules*",
		"textStreamViewer -t/etc/conf.modules -r20 -c80" },
 { NULL, "dmesg", "",    
 	"Print important kernel messages", "P dmesg",
		"textStreamViewer -tSystem_Messeges -r40 -c120" },
 { NULL, "devices", "",    "/proc/devices", "P cat /proc/devices",
		"textStreamViewer -t/proc/devices -r24 -c30" },
 { NULL, "dma", "",    "/proc/dma", "P cat /proc/dma",
		"textStreamViewer -t/proc/dma -r5 -c30" },
 { NULL, "interrupts", "",    "/proc/interrupts", "P cat /proc/interrupts",
		"textStreamViewer -t/proc/interrupts -r16 -c50" },
#else
 { NULL, "syslog", "",    
 	"Print important system messages", "P tail -300 /var/adm/syslog",
		"textStreamViewer -tSystem_Messeges -r40 -c120" },
#endif
#ifdef LINUX
 { "Misc", "CPU Info",  "C",    
 	"Display CPU information", "P cat /proc/cpuinfo",
		"textStreamViewer -tCPU_Info -r21 -c80" },
 { NULL, "Load",   "L",    
 	"load on the CPU", "T uptime | sed -e 's/^.*load/load/'",
		"textStreamViewer -tLoad -r1 -c40" },
 { NULL, "ioports", "",    "/proc/ioports", "P cat /proc/ioports",
		"textStreamViewer -t/proc/ioports -r27 -c40" },
 { NULL, "pci", "",    "/proc/pci", "P cat /proc/pci",
		"textStreamViewer -t/proc/pci -r24 -c120" },
 { NULL, "X11 Config",   "",    
 	"X11R6 Config File", "P cat /etc/X11/XF86Config",
		"textStreamViewer -tXF86Config -r40 -c80" },
#endif
 { NULL, "Display",   "",    
 	"Display info", "P xdpyinfo",
		"textStreamViewer -tXdpyinfo -r40 -c80" },
 { NULL, "Window",   "",    
 	"Window info", "P xwininfo",
		"textStreamViewer -tXwininfo -r40 -c80" },
#ifdef LINUX
 { "Memory", "Use",  "",    "Memory Usage", "P cat /proc/meminfo",
		"textStreamViewer -tMem_Info -r12 -c70" },
 { NULL, "Free",  "",    "Free memory report", "P free",
		"textStreamViewer -tFreeMemory -r6 -c80" },
 { NULL, "Vmstat",  "",    "Virtual memory report", "P vmstat",
		"textStreamViewer -tVirtualMemory_Status -r6 -c80" },
 { NULL, "Shared Mem",  "",    "ipcs -a", "P ipcs -a",
		"textStreamViewer -tSharedMemory_Summary -r25 -c80" },
#else
 { NULL, "Shared Mem",  "",    "ipcs -a", "P ipcs -a",
		"textStreamViewer -tSharedMemory_Summary -r25 -c132" },
#endif
 { NULL, "Time",  "",    "ipcs -t", "P ipcs -t",
		"textStreamViewer -tSharedMemory_Time -r25 -c80" },
 { NULL, "Pid",  "",    "ipcs -p", "P ipcs -p",
		"textStreamViewer -tSharedMemory_Pid -r25 -c80" },
 { NULL, "Creator",  "",    "ipcs -c", "P ipcs -c",
		"textStreamViewer -tSharedMemory_Creator -r25 -c80" },
 { NULL, "Limits",  "",    "ipcs -l", "P ipcs -l",
		"textStreamViewer -tSharedMemory_Limits -r25 -c80" },
 { NULL, "Sum",  "",    "ipcs -s", "P ipcs -s",
		"textStreamViewer -tSharedMemory_Summary -r25 -c80" },
#ifdef LINUX
 { "Disk", "Usage",  "",    "Disk Space Used", "P df",
		"textStreamViewer -tDisk_Usage -r6 -c80" },
 { NULL, "Mounted",  "",    "Disks Mounted", "P mount",
		"textStreamViewer -tDisks_Mounted -r6 -c80" },
 { NULL, "Table",  "",    "Mount Table", "P cat /etc/fstab",
		"textStreamViewer -tDisk_Mount_Table -r14 -c80" },
 { NULL, "Partitions",  "",    "Disk Paritions", "P cat /proc/partitions",
		"textStreamViewer -tDisk_Partitions -r14 -c50" },
 { NULL, "Swap Info",  "",    "Display info about Swap Space", "P /sbin/swapon -s",
		"textStreamViewer -tSwapInfo -r8 -c80" },
#else
 { "Disk", "Usage",  "",    "Disk Space Used", "P df -k",
		"textStreamViewer -tDisk_Usage -r12 -c80" },
 { NULL, "Mounted",  "",    "Disks Mounted", "P /sbin/mount",
		"textStreamViewer -tDisks_Mounted -r10 -c80" },
 { NULL, "Table",  "",    "Mount Table", "P cat /etc/*fstab",
		"textStreamViewer -tDisk_Mount_Table -r18 -c132" },
 { NULL, "Swap Info",  "",    "Display info about Swap Space", 
		"P /usr/sbin/swap -s; /usr/sbin/swap -l",
		"textStreamViewer -tSwapInfo -r8 -c80" },
 { NULL, "SAR: Disk", "",    
 	"Produce sys activity report", "P sar -d",
		"textStreamViewer -tSarDisk -r40 -c80" },
 { NULL, "File", "",    
 	"Produce file access activity report", "P sar -a",
		"textStreamViewer -tSarFileAccess -r40 -c80" },
 { NULL, "Swap", "",    
 	"Produce swap activity report", "P sar -w",
		"textStreamViewer -tSarSwap -r40 -c80" },
 { NULL, "Page1", "",    
 	"Produce paging activity report part 1", "P sar -p",
		"textStreamViewer -tSarPage1 -r40 -c80" },
 { NULL, "Page2", "",    
 	"Produce paging activity report part 2", "P sar -g",
		"textStreamViewer -tSarPage2 -r40 -c80" },
#endif
 { "Processes", "text top",  "t", 
 	"Display top processes in xterm window", "X top", NULL },
#ifdef LINUX
 { NULL, "kde top",  "k",     
 	"Display top processes using kde tool", "G ktop", NULL },
 { NULL, "gnome top",  "g",     
 	"Display top processes using gnome tool", "G gtop", NULL },
#endif
 { NULL, "All",   "a",    
 	"display all processes", "P ps -efl",
		"textStreamViewer -tAll_Processes -r40 -c160" },
#ifdef LINUX
 { NULL, "Mine",   "a",    
 	"display my processes", "P ps uxf",
		"textStreamViewer -tMy_Processes -r40 -c80" },
 { NULL, "Run Levels",   "",  "Display run levels for system processes", "P /sbin/chkconfig --list",
		"textStreamViewer -tRun_Levels -r40 -c80" },
#else
 { NULL, "Mine",   "a",    
 	"display my processes", "P ps -u 102 -f",
		"textStreamViewer -tMy_Processes -r40 -c140" },
 { NULL, "SAR: Buffer", "",    
 	"Produce sys activity report", "P sar -b",
		"textStreamViewer -tSarBuffer -r40 -c80" },
 { NULL, "TTY", "",    
 	"Produce tty activity report", "P sar -y",
		"textStreamViewer -tSarTTY -r40 -c80" },
 { NULL, "Calls", "",    
 	"Produce calls activity report", "P sar -c",
		"textStreamViewer -tSarCalls -r40 -c80" },
 { NULL, "Queue", "",    
 	"Produce run queue activity report", "P sar -q",
		"textStreamViewer -tSarRunQueue -r40 -c80" },
 { NULL, "Process", "",    
 	"Produce process activity report", "P sar -v",
		"textStreamViewer -tSarProcess -r40 -c80" },
 { NULL, "Unused", "",    
 	"Produce unused pages and disk blocks report", "P sar -r",
		"textStreamViewer -tSarUnused -r40 -c80" },
 { NULL, "Kernel", "",    
 	"Produce kernel memory allocation report", "P sar -k",
		"textStreamViewer -tSarKernel -r40 -c80" },
#endif
 { "Users", "Logged In",  "", 
 	"Who is logged in", "P who", 
		"textStreamViewer -t\"Who is logged in\" -r30 -c55" },
 { NULL, "Recently",  "", 
 	"Recent login/logout and boot times", "P last",
		"textStreamViewer -tRecent_Login_times -r40 -c80" },
 { NULL, "Doing",  "", 
 	"Who is logged in and what are they doing", "P w",
		"textStreamViewer -tW -r20 -c80" },
 { NULL, "Accounts",  "", "Password file", "P cat /etc/passwd",
		"textStreamViewer -t/etc/passwd -r24 -c80" },
 { NULL, "Groups",  "", "Groups file", "P cat /etc/group",
		"textStreamViewer -t/etc/group -r34 -c80" },
#ifdef LINUX
 { NULL, "Usage",  "", "Accounting of daily usage", "P ac -dp",
		"textStreamViewer -tUser_Accounting -r24 -c60" },
#endif
 { NULL, "Timed Jobs",  "", "Cron jobs for you", "P crontab -l",
		"textStreamViewer -tMy_Crontab -r12 -c80" },
#ifdef LINUX
 { "Network", "Inet",  "", "Display Internet network connections", "P netstat -n -Ainet", 
 		"textStreamViewer -tIneternet_Connections -r30 -c83"},
#else
 { "Network", "Inet",  "", "Display Internet network connections", "P netstat -n -finet", 
 		"textStreamViewer -tIneternet_Connections -r30 -c83"},
#endif
 {  NULL,      "All-n",  "", "Display all network connections", "P netstat -n", 
 		"textStreamViewer -tAll_Connections -r30 -c120"},
 {  NULL,      "All",  "", "Display all network connections", "P netstat", 
 		"textStreamViewer -tAll_Connections -r30 -c120"},
 { NULL,      "Interfaces",  "", "Display network interface info", "P netstat -i", 
 		"textStreamViewer -tNetwork_Interfaces -r18 -c83"},
 { NULL,      "Routes",  "", "Display network routing info", "P netstat -r", 
 		"textStreamViewer -tRouting_Info -r6 -c83"},
#ifdef LINUX
 { NULL,      "Status",  "", "Display interface status", "P /sbin/ifconfig", 
 		"textStreamViewer -tNetwork_Interface_Info -r18 -c83"},
 { NULL, "Users",  "", "Users on the local network", "P rusers",
		"textStreamViewer -tNetwork_Users -r12 -c60" },
#endif
 { NULL, "DNS",  "", "Display /etc/resolv.conf", "P cat /etc/resolv.conf",
		"textStreamViewer -tNameServers -r6 -c30" },
#ifdef LINUX
 { NULL, "arp",  "", "Display Low Level Address Routing Info", "P /sbin/arp -a",
		"textStreamViewer -tArpInfo -r6 -c70" },
#else
 { NULL, "arp",  "", "Display Low Level Address Routing Info", "P /usr/sbin/arp -a",
		"textStreamViewer -tArpInfo -r6 -c70" },
#endif
#ifdef LINUX
 { "Info", "ASCII",  "", "Display ascii table", "X man 7 ascii", NULL },
 {   NULL, "Signals", "", "Display info about signals", "X man 7 signal", NULL },
 {   NULL, "TTY Codes", "", "Display info about console codes", "X man 4 console_codes", NULL },
 {   NULL, "URI", "", "Display info on universal resource identifiers", "X man 7 uri", NULL },
 {   NULL, "Suffixes", "", "Display info on file suffixes", "X man 7 suffixes", NULL },
 {   NULL, "MIME", "", "MIME types", "P cat /etc/mime.types",
		"textStreamViewer -tMIME_Types -r32 -c80" },
 {   NULL, "crontab", "", "Display info on crontab", "X man 5 crontab", NULL },
 {   NULL, "fstab", "", "Display info on fstab", "X man 5 fstab", NULL },
#else
 { "Info", "ASCII",  "", "Display ascii table", "X man ascii", NULL },
 {   NULL, "Signals", "", "Display info about signals", "X man signal", NULL },
 {   NULL, "crontab", "", "Display info on crontab", "X man crontab", NULL },
 {   NULL, "vfstab", "", "Display info on vfstab", "X man vfstab", NULL },
 {   NULL, "boot", "", "Display boot info", "X man boot", NULL },
 {   NULL, "sar", "", "Display sar man page", "X man sar", NULL },
#endif
};

/* ------------------ Application resource structures  -------------------- */

typedef struct {
        int     debug_level;
	char   *config_file;
} ApplicationData, *ApplicationDataPtr;


ApplicationData  AppData;

static XtResource Resources[] = {
	{ "debug_level", "Debug_level", XtRInt, sizeof(int), 
	   XtOffset(ApplicationDataPtr, debug_level ), XtRString, "0"    },
	{ "config_file", "Config_file", XtRString, sizeof(int), 
	   XtOffset(ApplicationDataPtr, config_file ), XtRString, "DEFAULT" },
};


/* ----------------  Command line options structure  ---------------------- */

static XrmOptionDescRec Options[] = {
	{"-x",	"*debug_level",		XrmoptionStickyArg, NULL },
	{"-f",	"*config_file",		XrmoptionStickyArg, NULL },
};


/* ------------------------------- Actions -------------------------------- */

static void toggle_mem();
static void inc_debug();

static XtActionsRec actionsTable[] = {
	{ "toggle_mem",		toggle_mem 	} ,
	{ "inc_debug",		inc_debug 	} ,
};


/* ----------------------------- Translations ----------------------------- */

static char 
appWidgetTranslations[]="<Key>m:     toggle_mem()        	        \n \
		         <Key>x:     inc_debug()";

XtTranslations	 App_Trans_table;	/* Compiled translation table	*/

static XtAppContext MainContext;

void do_textViewer();
void do_command();

extern void xs_cmd_tip();

Widget Top_level, MainFormFW;

char *Title="System Information App Launcher";

Widget w;
main(argc, argv)
int argc;
char *argv[];
{
	Widget 		 parent, sw, label, button;
	int 		 rc, n;
	Arg 		 wargs[16];
	char		 *title_str;
	char		 *Config_file=NULL;

	setvbuf( stderr, NULL, _IOLBF, 0 );  /* Unbuffered output */
	setvbuf( stdout, NULL, _IOLBF, 0 );


	title_str = Title;

	/* Should be using XtOpenApplication - does it require Motif 2.0 ? */

	Top_level = XtAppInitialize( &MainContext, "SysInfoLaunchPad", Options, 
						    XtNumber(Options), 
						    &argc, argv,
						    NULL,
						    NULL, 0); 

	/* Load application resources */

	XtGetApplicationResources( Top_level, &AppData, Resources,
				             XtNumber(Resources), 
					     NULL, 0 );
	/* Register the new actions */

	XtAppAddActions( MainContext, actionsTable, XtNumber(actionsTable) );

	App_Trans_table = XtParseTranslationTable( appWidgetTranslations );

	Debug = AppData.debug_level;   /* Set the debug packages debug level */
	Config_file = AppData.config_file;

	/* Create a form to hold the menu and scrolled window  */

	MainFormFW = XtCreateManagedWidget( "mainForm", xmFormWidgetClass,
							Top_level, NULL, 0 );
	parent    = MainFormFW;

	/* Use a config file to determine what launcher definition file to use
	 * if none found then use this builtin set.
	 */

	if ( strcmp( Config_file, "DEFAULT" ) != 0 )
	{
		/* go ahead! implement it!!!!*/
		printf("loading from file not implemented yet\n"); 
		exit(0);
	}
	else
		createDefaultLaunchPad( parent );

	XtAugmentTranslations( MainFormFW, App_Trans_table );

	n = 0;
	XtSetArg( wargs[n], XmNtitle, title_str); n++;
	XtSetValues( Top_level, wargs, n );

	XtRealizeWidget( Top_level );
	XtAppMainLoop( MainContext );
}


createDefaultLaunchPad( parent )
Widget parent;
{
	Widget 		 label, button, attach_top, attach_left, attach_top_last;
	int 		 i, n, row, numCommands;
	Arg 		 wargs[16];
	CommandEntry    *p;
	int		 firstRowButton = 1;
	int		 firstRowLabel = 1;
	char		labelString[120];
	int		ColonPosition=15;

	numCommands = sizeof( Commands ) / sizeof( CommandEntry );

	/* printf( "numCommands = %d\n", numCommands ); */

	row = 0;
	for ( i = 0 ; i < numCommands ; i++ )
	{
		p = &(Commands[i]);
		/* printf("[%d] - %s %s %s (%s) (%s)\n", row, p->Category, p->label, 
						p->shortCut, p->tooltip, 
						p->command ); */

		/* if ( (p->Category) == NULL || ( strlen(p->Category) == 0 ) ) */
		if ( (p->Category) == NULL )
		{
		    n = 0;
		    if ( firstRowButton )  /* So attach to form */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else  /* not the first row so attach to widgets */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }

		    
		    XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
		    XtSetArg( wargs[n], XmNleftWidget, attach_left); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 2); n++;
		    button = XtCreateManagedWidget( p->label, xmPushButtonWidgetClass,
						parent, wargs, n );


		    XtAddCallback( button, XmNactivateCallback, do_command, p);
		    if ( p->command[0] == 'T' )
		        xs_cmd_tip( button, &(p->command[2]) );
		    xs_widget_tip( button, p->tooltip );


		    attach_left = button;  
		}
		else  /* Starting New Row */
		{
		    n = 0;
		    if ( firstRowLabel )   /* First Row */
		    {
			firstRowLabel = 0;
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else
		    {
		        firstRowButton = 0;

		        attach_top  = attach_top_last;

			/* Adjust the label in the row above to be vertically centered */

			n = 0;
			XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
			XtSetArg( wargs[n], XmNbottomWidget, attach_top_last); n++;
			XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
			XtSetArg( wargs[n], XmNtopWidget, attach_top_last); n++;
			XtSetValues( label, wargs, n ); 

		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }


		    XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
		    XtSetArg( wargs[n], XmNrightPosition, ColonPosition); n++;
		    XtSetArg( wargs[n], XmNrightOffset, 2); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 2); n++;
		    if ( strlen( p->Category ) > 0 )
		        sprintf( labelString, "%s:", p->Category );
		    else
		        strcpy( labelString, " " );
		    label = XtCreateManagedWidget( labelString, xmLabelWidgetClass,
						parent, wargs, n );

		    /* Now add the first button in the row */

		    n = 0;
		    if ( firstRowButton )   /* First Row */
		    {
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_FORM);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 6); n++;
		    }
		    else
		    {
		        attach_top  = attach_top_last;
		        XtSetArg( wargs[n], XmNtopAttachment,XmATTACH_WIDGET);n++;
		        XtSetArg( wargs[n], XmNtopWidget, attach_top);n++;
		        XtSetArg( wargs[n], XmNtopOffset, 2); n++;
		    }

		    XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
		    XtSetArg( wargs[n], XmNleftPosition, ColonPosition); n++;
		    XtSetArg( wargs[n], XmNleftOffset, 4); n++;


		    button = XtCreateManagedWidget( p->label, xmPushButtonWidgetClass,
						parent, wargs, n );

		    XtAddCallback( button, XmNactivateCallback, do_command, p);

		    if ( p->command[0] == 'T' )
		        xs_cmd_tip( button, &(p->command[2]) );
		    xs_widget_tip( button, p->tooltip );

		    attach_top_last  = button;  
		    attach_left      = button;  

		    row++;
		    /* printf( "Row[%d]\n", row ); */
		}
	}

	n = 0;
	XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
	XtSetArg( wargs[n], XmNbottomWidget, attach_top_last); n++;
	XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
	XtSetArg( wargs[n], XmNtopWidget, attach_top_last); n++;
	XtSetValues( label, wargs, n ); 

	n = 0;
	XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg( wargs[n], XmNbottomOffset, 6); n++;
	XtSetValues( attach_top_last, wargs, n ); 
}

void
do_command( w, p, call_data)
Widget w;
CommandEntry *p;
caddr_t call_data;
{
    char command[256];
    char *cmd;

    cmd = p->command;

    /* printf("Command -> (%s)\n", cmd ); */

    if ( ( cmd[0] == 'P' ) || ( cmd[0] == 'T' ))  /* Execute and pipe to our own viewer */
    {
        if ( p->viewer ) /* override default viewer */
           sprintf( command, "sh -c \"%s | %s &\" ", &(cmd[2]), p->viewer );
	else
           sprintf( command, "sh -c \"%s | textStreamViewer -t%s&\" ", &(cmd[2]), p->label );


    	spawnExternal( command );
    }
    else if ( cmd[0] == 'G' )  /* A GUI tool */
    {
        sprintf( command, "%s &", &(cmd[2]) );

    	spawnExternal( command );
    }
    else if ( cmd[0] == 'X' )   /* use xterm */
    {
        sprintf( command, "xterm -ls -e %s &", &(cmd[2]) );

    	spawnExternal( command );
    }
    else
    {
    	printf("Command Type Unknown-> (%s)\n", cmd );
    }
}

int
spawnExternal( cmd )
char *cmd;
{
        system( cmd );
}

static void inc_debug()
{
	Debug++;
}
static void toggle_mem()
{
}
