/* icons.h:  Include file for icon handling structures
 *
 */

#ifndef TPS_ICONSH
#define TPS_ICONSH


#define MONOCHROME      0
#define LOW_COLOR       1
#define HIGH_COLOR      2

typedef struct icon_record {
	char 		   *name;	/* Matches filename */
	Pixmap	 	   icon_pixmap;	
	int		   icon_width;
	int		   icon_height;
	struct icon_record *next;
} Icon_record;




typedef struct icon_list {
	char 		*name; /* Matches directory name */
	Icon_record 	*first;
} Icon_list;




typedef struct icon_set {
	char	  *name;	/* Matches dir name */
	Icon_list *size16;
	Icon_list *size22;	/* KDE Toolbar size */
	Icon_list *size32;
	Icon_list *size48;
	Icon_list *size64;
} Icon_set;




typedef struct icon_space {
	Icon_set *mono;
	Icon_set *loColor;
	Icon_set *hiColor;
} Icons;



#endif /* TPS_ICONSH */
