/* File: 	color_code.h
 *
 * Description: Include file for color_code structures and routines
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	3/8/95	Created
 *
 */

#ifndef COLORCODEH
#define COLORCODEH


/* A generic object color coding structure, used to build lists of user and
 * group colors.
 */

typedef struct _obj_color {
	int	 id;
	char	*name;
	char	*fg_str;
	char	*bg_str;
	Pixel    fg;
	Pixel    bg;
	struct _obj_color *next;
} Object_color;


#define NO_COLOR				0
#define COLOR_BY_REAL_USER_ID			1
#define COLOR_BY_EFFECTIVE_USER_ID		2
#define COLOR_BY_REAL_GROUP_ID			3
#define COLOR_BY_EFFECTIVE_GROUP_ID		4
#define COLOR_BY_TOTAL_TIME			5
#define COLOR_BY_LOAD				6
#define COLOR_BY_STATUS				7
#define COLOR_BY_RESIDENT_PAGES			8
#define COLOR_BY_IMAGE_SIZE			9
#define COLOR_BY_PRIORITY			10



/* A structure used to define a range of values and a color pair  */

typedef struct _range_color {
	char    *label;
	Boolean selected;	/* When range is selected */
	double  min;
	double  max;
	int     count;		/* Frequency count */
	Pixel   fg;
	Pixel   bg;
} Range_color;


#define MAX_COLOR_RANGES			256

/* A structure to define a color range map - i.e. many ranges and colors */

typedef struct _range_map {
	char		*label;		/* Name of color map               */
	Boolean		 selections;	/* Set true when selections made   */
	int              count;         /* Number of elements in array     */
	Range_color     *range;         /* Array of range values -> colors */
} Range_color_map;


extern int Color_bar_count_mode;
extern int Color_bar_averaging;

Object_color  *parse_object_colors();
Object_color  *create_object_color();
Object_color  *push_object_list();
void 	       match_color_to_username();
void 	       match_color_to_groupname();
Object_color  *find_obj_color_by_id();

void	       get_node_colors();
void	       set_node_colors();


#endif /* COLORCODEH */
