/* File: remove_lnode.c 
 *
 * Description:   
 *	        Find and remove the list member with the supplied key
 *
 *		NOTE: This function does NOT free the member data
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */


lnode
*remove_lnode( list, old_key )		/* Find and remove */
lnode *list;
int    old_key;
{
	lnode *ptr, *last_ptr;

	if ( list == NULL_LNODE_PTR )
		return( list );

	for ( ptr = list ; ptr != NULL_LNODE_PTR ; ptr = ptr->next )
	{
		if ( ptr->key == old_key )
			break;
		last_ptr = ptr;
	}

	if ( ptr == NULL_LNODE_PTR )		/* not in list */
		return( list );

	if ( ptr == list )	/* Remove from front of list */
	{
		list = ptr->next;
	}
	else  			/* Remove from middle or end */
	{
		last_ptr->next = ptr->next;
	}

	ptr->data = NULL;	/* So we DON'T destroy application data  */

	destroy_lnode( ptr );

	return( list );
}
