/* File: merge_lists.c 
 *
 * Description:   
 *	        Create a new list which is the union of the two supplied lists
 *
 *		NOTE: The old lists remain intact after the call. The new
 *		      list does not copy the data from the old list's
 *		      instead it just set's pointers to the original data.
 *
 *		Be very careful when freeing a merged list!!!
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */

lnode
*merge_lists( list1, list2 )	/* Create new list with union of lists */
lnode *list1;
lnode *list2;
{
	lnode *p;
	lnode *new_list=NULL_LNODE_PTR;
	lnode *new; 
	lnode *last=NULL_LNODE_PTR;

	
	for ( p = list1 ; p != NULL_LNODE_PTR; p = p->next )
	{
		new = construct_lnode( p->key, p->data );

		if ( new_list == NULL_LNODE_PTR )
			new_list = new;
		else
			last->next = new;

		last = new;
	}

	for ( p = list2; p != NULL_LNODE_PTR; p = p->next )
	{
		new_list = fwd_insert_lnode( new_list, p->key, p->data );
	}

	return( new_list );
}
