/* File: lists_equal.c 
 *
 * Description:   
 *	        Checks lists for equality, does not check contents.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */

lists_equal( old, new )
lnode *old;
lnode *new;
{
	lnode *n, *o;

	n = new; 
	o = old;
	while ( n && o )
	{
		if ( n->key != o->key )  
			return( False );

		n = n->next;
		o = o->next;
	}

	if ( n || o )
		return( False );

	return( True );
}

lists_not_equal( old, new )
lnode *old;
lnode *new;
{
	lnode *n, *o;

	n = new; 
	o = old;
	while ( n && o )
	{
		if ( n->key != o->key )  
			return( True );

		n = n->next;
		o = o->next;
	}

	if ( n || o )
		return( True );

	return( False );
}
