/* File: fwd_insert_lnode.c 
 *
 * Description:   
 *	        Create and Insert a new lnode in the supplied list maintaining
 *		forward ordering. Return the modified list, possibly with
 *		a new head.
 *
 *		NOTE: If a node already exists with the supplied key the
 *		      new node is not added and  _new_list_entry is set to 0.
 *
 *		      If the node was created and added _new_list_entry is
 *		      set to 1.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */

#include <stdio.h>

#include "list.h"	/* Package definitions */

int _new_list_entry=0;

lnode
*fwd_insert_lnode( list, key, data )
lnode *list;
int    key;
void  *data;
{
	lnode *new_node, *ptr, *last_ptr;

	_new_list_entry=0;

	new_node = construct_lnode( key, data );
	if ( new_node == NULL_LNODE_PTR )
		return( list );

	/* Sorted insertion, increasing numbers as list depth increases */

	if ( list == NULL_LNODE_PTR )
		list = new_node;
	else
	{
		/* Find position in list in which to insert the new node */
		last_ptr = list;
		for ( ptr = list; ptr != NULL_LNODE_PTR; ptr = ptr->next )
		{
			if ( new_node->key <= ptr->key )
					break;

			last_ptr = ptr;
		}

		if ( ptr && ( new_node->key == ptr->key) )  
		{
			/* Already present, no dups!*/

			/* We null out the data pointer so we don't free users 
			 * data by accident. They should track the
			 * _new_list_entry variable and do it themselves
			 */

			new_node->data = NULL;
			destroy_lnode( new_node );
			return( list );
		}

		_new_list_entry++;
		if ( ptr == NULL_LNODE_PTR )  	/* append to list 	  */
		{
			last_ptr->next = new_node;
		}
		else if ( ptr == list )  	/* Insert at head of list */
		{
			new_node->next = list;
			list = new_node;
		}
		else				/* Into the middle of list */
		{
			last_ptr->next = new_node;
			new_node->next = ptr;
		}
	}

	return( list );
}

