/* File: free_list.c 
 *
 * Description:   
 *	        Walk the list and destroy all members, return a NULL
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */

lnode
*free_list( head )
lnode *head;
{
	lnode *ptr, *next_ptr;

	for ( ptr = head ; ptr != NULL_LNODE_PTR; ptr = next_ptr )
	{
		next_ptr = ptr->next;
		destroy_lnode( ptr );
	}

	return( NULL_LNODE_PTR );
}
