/* File: diff_rev_lists.c 
 *
 * Description:   
 *	        Create a list of additions and deletions required to modify
 *		the supplied old list to create the supplied new list.
 *
 *		Note: Lists Must be reverse ordered!!
 *
 *		Addition and deletion lists are reverse ordered.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>

#include "list.h"	/* Package definitions */


void
diff_rev_lists( old, new, add, del )	/* Lean. mean diff machine!! */
lnode *old;
lnode *new;
lnode **add;
lnode **del;
{
	lnode *n, *o;

	*add = free_list( *add );
	*del = free_list( *del );

	n = new; 
	o = old;
	while ( n && o )
	{
		if ( n->key == o->key )  /* No change */
		{
			n = n->next;
			o = o->next;
		}
		else if ( n->key > o->key )
		{
			*add = rev_insert_lnode( *add, n->key, NULL );
			n = n->next;
		}
		else if ( n->key < o->key )
		{
			*del = rev_insert_lnode( *del, o->key, NULL );
			o = o->next;
		}
	}

	while ( n )
	{
		*add = rev_insert_lnode( *add, n->key, NULL );
		n = n->next;
	}

	while ( o )
	{
		*del = rev_insert_lnode( *del, o->key, NULL );
		o = o->next;
	}
}

