/* File: destroy_lnode.c 
 *
 * Description:   
 *	            Destroy lnode, assumes it's not in a list
 *
 *		NOTE: Also free's space pointed to by the data member
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/08/95	Created
 *         	George MacDonald	4/11/95	Broke out into seperate file
 *            
 */


#include <stdio.h>
#include <stdlib.h>

#include "list.h"	/* Package definitions */


void
destroy_lnode( ptr )
lnode *ptr;
{
	if ( ptr == NULL_LNODE_PTR )
		return;

	if ( ptr->data != NULL )   /* Assuming data was malloced */
		free( ptr->data );

	free( ptr );
}

