/* Utility routine to convert an array of strings into
 * one large compound string with appropriately inserted separators
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

XmString 
xs_str_array_to_xmstr( strv, strc )
char *strv[];
int   strc;
{
	XmString xmstr;
	int i;

	if ( strc <= 0 )
		return( XmStringCreate("", XmSTRING_DEFAULT_CHARSET));

	xmstr = (XmString) NULL;

	for ( i = 0 ; i < strc ; i++ )
	{
		if ( i > 0 ) /* prepend all but first word with a space */
		{
			xmstr = XmStringConcat(xmstr, 
					XmStringSeparatorCreate());
		}

		xmstr = XmStringConcat(xmstr, XmStringCreate(strv[i], 
						XmSTRING_DEFAULT_CHARSET));
	}

	return( xmstr );
}
