
/* Create menu buttons */

#include <stdlib.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>

#include "libXs.h"


void
xs_create_menu_buttons( title, menu , menulist, nitems)
char         *title;
Widget        menu;
xs_menu_struct    *menulist;
int        nitems;
{
    Arg        wargs[4];
    int        i, n;
    WidgetList    buttons;
    int        separators=0;
    Widget    help_button=NULL;
    int	      radio=0;
    int	      default_sel_pos;

    if ( menu == NULL )
    {
	printf("ERROR: no top level widget supplied to create_menu\n");
	return;
    }

    /* Allocate space to hold button widget list */

    buttons = (WidgetList) XtMalloc(nitems * sizeof(Widget));

    if ( title != NULL_STR )
    {
        XtCreateManagedWidget( title, xmLabelWidgetClass, menu,
                    NULL, 0 );
        XtCreateManagedWidget( title, xmSeparatorWidgetClass, menu,
                    NULL, 0 );
    }

    for ( i = 0 ; i < nitems; i++ )
    {
        /* A NULL represents a separator */

        if ( strcmp( menulist[i].name, "Sep") == 0 )	
        {
            XtCreateManagedWidget( "sep", xmSeparatorWidgetClass, 
                    menu, NULL, 0 );
            separators++; /* Count how many items arn't buttons */
        }
        else if ( strcmp( menulist[i].name, "TearOff") == 0 )	
	{
#ifdef TEAR_OFFS	
        	n = 0;
        	XtSetArg( wargs[n], XmNtearOffModel, XmTEAR_OFF_ENABLED ); n++;
        	XtSetValues( menu, wargs, n );
#endif
            	separators++; /* Count how many items arn't buttons */
	}
        else if ( strcmp( menulist[i].name, "Radio") == 0 )	
	{
		radio++;
        	n = 0;
        	XtSetArg( wargs[n], XmNradioBehavior, True ); n++;
        	XtSetValues( menu, wargs, n );

            	separators++; /* Count how many items arn't buttons */
		default_sel_pos = atoi( menulist[i].mnemonic );
	}
        else if ( menulist[i].func != NULL ) /* Menu item with a callback */
        {

            /* If there is a name and a callback, create a 
             * selectable menu entry and register the callback 
             * function.
              */

            n = 0;
            if ( menulist[i].mnemonic != NULL_STR )
            {
                XtSetArg( wargs[n], XmNmnemonic, menulist[i].mnemonic[0] ); n++;
            }

            if ( menulist[i].accelerator != NULL_STR )
            {
                XtSetArg(wargs[n], XmNaccelerator, menulist[i].accelerator);n++;
            }


	    if ( radio )
	    {
            	buttons[i-separators] = XtCreateManagedWidget( menulist[i].name,
                    xmToggleButtonWidgetClass, 
                    menu, wargs, n );

            	XtAddCallback(buttons[i-separators],XmNvalueChangedCallback,
                    menulist[i].func, menulist[i].data );

	    	if ( (i-separators) == default_sel_pos )
		{
			/* Set it, but don't invoke callback */
                	XmToggleButtonSetState( buttons[i-separators], 
								True, False );
		}
	    }
	    else
	    {
            	buttons[i-separators] = XtCreateManagedWidget( menulist[i].name,
                    xmPushButtonWidgetClass, 
                    menu, wargs, n );

            	XtAddCallback(buttons[i-separators],XmNactivateCallback,
                    menulist[i].func, menulist[i].data );
	    }

        }
        else if ( menulist[i].sub_menu == NULL )
        {
            /* If no submenu and no callback, then it's a label */

            buttons[i-separators] = XtCreateManagedWidget( menulist[i].name, 
                    xmLabelWidgetClass, 
                    menu, NULL, 0 );
        }
        else    /* We got a submenu entry, setup and then recurse */
        {
            Widget sub_menu_widget;


	    if ( menulist[i].sub_menu_title == NULL_STR )
                  sub_menu_widget = XmCreatePulldownMenu(menu,
                                            NULL_STR, NULL, 0);
	    else
                  sub_menu_widget = XmCreatePulldownMenu(menu,
                                            menulist[i].sub_menu_title,
                                            NULL, 0);

            n = 0;
            if ( menulist[i].mnemonic != NULL_STR )
            {
               XtSetArg( wargs[n], XmNmnemonic, menulist[i].mnemonic[0] ); n++;
            }
            if ( menulist[i].accelerator != NULL_STR )
            {
                XtSetArg(wargs[n], XmNaccelerator, menulist[i].accelerator);n++;
            }

            XtSetArg( wargs[n], XmNsubMenuId, sub_menu_widget ); n++;
            buttons[i-separators] = XtCreateWidget( menulist[i].name,
                                        xmCascadeButtonWidgetClass,
                                        menu, wargs, n);

            if ( strcmp( menulist[i].name, "Help" ) == 0 )
                help_button = buttons[i-separators];
            xs_create_menu_buttons( menulist[i].sub_menu_title,
                                    sub_menu_widget, 
				    (xs_menu_struct *)  menulist[i].sub_menu,
                       		    menulist[i].n_sub_items);
        }
    }

    /* Manage all buttons, menu panes are not managed */

    XtManageChildren( buttons, nitems - separators );

    if ( help_button != NULL )
    {
        n = 0;
        XtSetArg( wargs[n], XmNmenuHelpWidget, help_button ); n++;
        XtSetValues( menu, wargs, n );
    }

    XtFree( (char * ) buttons );
}

