/* libXs.h:   Miscelaneous X routines Header file 
 *
 */


#ifndef NULL_STR
#define NULL_STR ((char *) NULL)
#endif


/* The following structure  is used for menu construction */

typedef struct _menu_struc {
	char 	*name;		/* Used as the menu item name */
	char 	*mnemonic;	/* If non-null Use first char as mnemonic */
	char 	*accelerator;	/* If non-null An accelerator */
	void	(*func)();	/* Function to call when selected */
	caddr_t	data;		/* Call data for callback function  */
	struct  _menu_struct	*sub_menu;	/* If a sub menu present */
	int	n_sub_items;
	char	*sub_menu_title;
} xs_menu_struct;


/* The following structure is used for rubberbanding a line or box  */

typedef struct _rubber_band_data {
	int	in_band;		/* Set when start, unset on end */
	int	start_x;
	int	start_y;
	int	last_x;
	int	last_y;
	GC	gc;
} xs_rubber_band_data;


#define INT_FIELD		1
#define FLOAT_FIELD		2
#define BOOLEAN_FIELD		3
#define STRING_FIELD		4
#define ENUMERATED_FIELD	5

typedef struct _field_set_entry {
	int	 type;			/* One of above types               */
	void	*loc;			/* Pointer to location of the value */
	int  	 avail;			/* Whether or not it's sensistive   */
	Widget	 field;			/* Visualizer widget                */
} xs_field_set_entry;


extern void 	xs_start_rubber_line();
extern void 	xs_end_rubber_line();
extern void 	xs_track_rubber_line();
extern void 	xs_start_rubber_box();
extern void 	xs_end_rubber_box();
extern void 	xs_track_rubber_box();

extern XmString xs_concat_words();
extern XmString xs_str_array_to_xmstr();
extern void	xs_insert_string();

extern Widget 	xs_create_quit_button();

extern void	xs_create_menu_buttons();

extern void	xs_talkto();

extern void	xs_wprintf();

extern GC	xs_create_xor_gc();
extern void	xs_invert_fgbg();

extern Widget	xs_step();


extern Widget   xs_create_int_field();
extern Widget   xs_create_float_field();
extern Widget   xs_create_boolean_field();
extern Widget   xs_create_string_field();
extern Widget   xs_create_enum_field();
extern Widget   xs_create_file_field();

extern int   	xs_set_int_field();

extern int   	xs_widget_tip();

