/* treesort.c: Display a binary sort tree using the tree widget
 *
 */


#include <varargs.h>
#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ScrolledW.h>

#include <Xpsi/Tree.h>

#include "debug.h"

int Debug=0;

/* Define the structure for a node in the binary sort tree */

typedef struct _node {
	int	key;
	struct	_node	*left;
	struct	_node	*right;
} node;


extern node *insert_node();
extern node *make_node();

void xs_wprintf();

main(argc, argv)
int argc;
char *argv[];
{
	Widget 	toplevel, sw, tree;
	node	*head = NULL;
	int	digit;
	Arg 	wargs[14];
	int 	i, n;


	toplevel = XtInitialize( argv[0], "Treesort", NULL, 0, &argc, argv);

	/* Put the tree in a scrolled window to handle large tree's */


/*
	n = 0;
	XtSetArg( wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;

	sw = XtCreateManagedWidget( "swindow",  xmScrolledWindowWidgetClass,
						toplevel, wargs, n );
*/
	sw = XtCreateManagedWidget( "swindow",  xmScrolledWindowWidgetClass,
						toplevel, NULL, 0 );
	/* Create the tree widget */

	n = 0;
/* 	XtSetArg( wargs[n], XtNtreeOrientation, RIGHT_TO_LEFT ); n++; */
	XtSetArg( wargs[n], XtNconnectionStyle, TIER_CONNECTION ); n++; 
	XtSetArg( wargs[n], XtNhorizontalSpace, 8 ); n++; 
	tree = XtCreateManagedWidget( "tree",  xpsiTreeWidgetClass, 
						sw, wargs, n );

	/* create a binary sort tree from data read from stdin */

	while( scanf("%d", &digit) != EOF )
	{
		head = insert_node( digit, head );
	}

	/* Create the widgets representing the tree */

	show_tree( tree, head, NULL );

	XtRealizeWidget( toplevel );
	XtMainLoop();
}


node
*insert_node( key, head )
int   key;
node *head;
{
	node *prev, *ptr = head;

	/* If the tree doesn't exist, just create and return a new node */

	if ( !head )
		return( make_node(key) );

	/* Otherwise, find a leaf node, always following the
	 * left branches if the key is less than the value in each
	 * node, and the right branch otherwise.
	 */

	while ( ptr != NULL )
	{
		prev = ptr;
		ptr = ( key < ptr->key ) ? ptr->left : ptr->right;
	}

	/* Make a new node and attach it to the appropriate branch */

	if ( key < prev->key )
		prev->left  = make_node( key );
	else
		prev->right = make_node( key );

	return( head );
}

node
*make_node( key )
int key;
{
	node *ptr = ( node *) malloc(sizeof(node));

	ptr->key = key;
	ptr->left = ptr->right = NULL;
	return( ptr );
}


show_tree( parent, branch, super_node )
Widget  parent;
node	*branch;
Widget  super_node;
{
	Widget  w;
	Arg	wargs[3];
	int	n;

	/* If we have hit a leave return */

	if ( !branch )
		return;

	/* Create a widget for the node, specifying the given super_node
	 * constraint.
	 */

	n = 0;
	XtSetArg( wargs[n], XtNparentWidget, super_node); n++;
	XtSetArg( wargs[n], XtNkey, branch->key); n++;
/*	w = XtCreateManagedWidget("node", xmLabelWidgetClass,  */
	w = XtCreateManagedWidget("node", xmPushButtonWidgetClass, 
					parent, wargs, n );

	xs_wprintf( w, "%d", branch->key );

	/* Recursively create the subnodes, giving this node's
	 * widget as the super_node
	 */

	 show_tree( parent, branch->left,  w );
	 show_tree( parent, branch->right, w );

}




void xs_wprintf(va_alist)
va_dcl
{
	Widget w;
	char *format;
	va_list args;
	char str[1000];
	Arg wargs[10];
	XmString xmstr;


	va_start(args);

	w = va_arg(args, Widget);

	if ( !XtIsSubclass( w, xmLabelWidgetClass ) )
		XtError("xs_wprintf() requires a label widget");

	format = va_arg(args, char *);

	vsprintf( str, format, args );

	xmstr = XmStringLtoRCreate( str, XmSTRING_DEFAULT_CHARSET);

	XtSetArg(wargs[0], XmNlabelString, xmstr);

	XtSetValues( w, wargs, 1);

	va_end( args );
}
