/* File: 	TreeP.h
 *
 * Description: Private Def's for the Xpsi Tree widget,  i.e.
 *
 *			Tree Class Record
 *			Tree Instance Record
 *
 *			Convenience Macros
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1993, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	10/10/93	Created
 *
 */


#ifndef TREEP_H
#define TREEP_H

#include <X11/CoreP.h>

#include <Xpsi/Tree.h>


/* --------------------     The Tree class record    --------------------*/

typedef struct _XpsiTreeClassPart {
	int ignore;
} XpsiTreeClassPart;


typedef struct _XpsiTreeClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	XpsiTreeClassPart	tree_class;
} XpsiTreeClassRec;

extern XpsiTreeClassRec xpsiTreeClassRec;

/* --------------------   The Tree instance record    --------------------*/


typedef struct
{
	Dimension      *array;
	int		size;
} TreeTable, *TreeTablePtr;


typedef struct _XpsiTreePart {
	TreeOrientation	orientation;	/* Tree orientation 		    */
	TreePacking	packing;	/* Tree packing 		    */
	ConnectionStyle connect_style;  /* Style of node connections        */
	NodeSize	node_size;	/* Tree fixed, level fixed, variable*/
	Dimension	min_x_pad;	/* Min horizontal space between nodes */
	Dimension	min_y_pad; 	/* Min vertical space between nodes */
	Dimension	path_pad;	/* space between pathway lines      */
	Boolean		node_shape;	/* Draw a surrounding node shape    */
	Boolean		resize_policy;  /* Set true if auto min size        */
	Pixel		foreground;	/* Default color of graphics        */

	Pixel		node_foreground;/* Default Color of node foreground */
	Pixel		node_background;/* Default Color of node background */

	TreeMargin	left_margin;	/* Offset from left border          */
	TreeMargin	right_margin;	/* Offset from right border         */
	TreeMargin	top_margin;	/* Offset from top border           */
	TreeMargin	bottom_margin;	/* Offset from bottom border        */

	Dimension	minWidth;	/* Minimum Width of widget	    */
	Dimension	minHeight;	/* Minimum height of widget         */

	ParentPlacement parents_place;	/* Positioning above child          */


	Widget		tree_root;	/* Top node of tree, always present */
	TreeTablePtr	horizontal_pos;	/* Layout positioning values        */
	TreeTablePtr	vertical_pos;	/*     Vertical positionings        */
	TreeTablePtr	max_width;	/* Max width on level               */
	TreeTablePtr	max_height;	/* Max height on level               */
	GC		gc;		/* Primary drawing graphics context */
	GC		node_fgc;	/* Node drawing graphics context */
	GC		node_bgc;	/* Node drawing graphics context */
	GC		draw_gc;	/* Node drawing graphics context */
	Dimension	max_x;		/* Max x required to show all tree  */
	Dimension	max_y;		/* Max y required to show tree      */
	int		depth;		/* Number of levels in tree         */
	Boolean		do_layout;	/* Set by XpsiDoTreeLayout          */
	Boolean		do_redisplay;	/* Set by XpsiDoTreeRedisplay       */
	Boolean		layout_unmanaged; /* See XpsiLayoutUnmanaged        */

	int		total_parents;	/* Used to calc num_con_lines       */
	int		total_children; /* Used to calc num_con_lines       */
	int		max_node_width;	/* For total tree symetery          */
	int		max_node_height;

	XSegment	*connect_lines;	    /* Connection line segments	    */
	int		num_connect_lines;  /* Number of connection lines   */
	int		max_connect_lines;  /* Max numb of connection lines */

	XRectangle	*rectangles;	/* Node rectangles		    */
	int		num_rectangles;
	int		max_rectangles;

	/* The following array matches the # of rectangles/arc used to draw
	 * the nodes. It is used to lookup the background pixel value
	 * to be used to fill arround the node, if required.
	 */

	Pixel		*fillColor;

	/*      Remaining elements used for Star topology only              */

	Boolean		show_rings;	/* Draw tree rings 		    */
	Pixel		ring_foreground;/* Color of ring foreground         */
	Pixel		ring_background;/* Color of ring background         */
	Boolean		center_root_x;	/* Root node centered in min window */
	Boolean		center_root_y;  /* Root node centerd in min window  */

	int      	min_x;		/* Minumim x, for star topology     */
	int      	min_y;		/* Min y calculated during layout   */
	TreeTablePtr	breadth;	/* Number of nodes at each level    */
	TreeTablePtr	cur_breadth;	/* Current node pos at each level   */
	TreeTablePtr	calc_breadth;	/* Calculated breadth, optimization */
	TreeTablePtr	ring_width;	/* Ring width at each level         */

	XArc		*arcs;		/* Arcs for nodes 		    */
	int		num_arcs;
	int		max_arcs;

	XArc		*rings;		/* Arc's for Tree rings             */
	int		num_rings;
	int		max_rings;

	GC		ring_fgc;	/* Ring drawing graphics context */
	GC		ring_bgc;	/* Ring drawing graphics context */

	XtCallbackList	treeResize;	/* Callback List 		 */

} XpsiTreePart;

typedef struct _XpsiTreeRec {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
	XpsiTreePart	tree;
} XpsiTreeRec;


typedef struct _ChildPtr
{
	Widget			child;
	struct	_ChildPtr	*next;
} ChildPtr;

typedef ChildPtr *ChildList;

typedef struct _TreeConstraintsPart
{
	Widget		parent;
	int		key;		/* Unique key, used to sort nodes */
	Position	x,y;
	Position	radius;		/* Radius of surrounding circle   */
	ChildList	children;
	int		num_children;
	int		layout_cnt;   /* # of kids to consider during layout */

	/* The following are for pathway routing */

	int		rel_posn;   /* Relative position of node from parent */
	int		maxNumParallelRouteLines; /*between this and children*/
	int		superior_cnt; /* # children positionaly above/left */
	int 		inferior_cnt; /* # children positionaly below/right*/

	/* The following is for node filling, when needed */

	Pixel		node_background;
	Pixel		backgroundFill;

	GC		node_gc;	
	int		shapeIndex;

	/*		Later Add these for individual node/connect colors

	Pixel		node_shape_foreground;
	Pixel		node_shape_background;
	GC		node_shape_gc;

			connection_color
			connection_thickness
			connection_style
	GC		node_connection_gc;

	  Or use a more powerful callback mechanism, such as

	XtCallbackList	drawShape;	
	XtCallbackList	drawConnection;	

		cept can't get to work - sigh

	*/

	void	*drawShape;	
	void	*drawShapeArg;	
	void	*drawConnection;	
	void	*drawConnectionArg;	

} TreeConstraintPart;

typedef struct _TreeConstraintRec 
{
	TreeConstraintPart	tree;
} TreeConstraintRec, *TreeConstraints;

#define DEFAULT_TABLE_DEPTH	32

#define TREE_CONSTRAINT(w)  ((TreeConstraints) ((w)->core.constraints))

#endif 	/* TREEP_H */
