/* Tree.h: Public header file for the Xpsi Tree Widget
 *
 *	Resource 		Resource
 *	  Name			  Class			Default Value
 * 	------------------	-------------------	---------------------
 *
 *	treeOrientation 	TreeOrientation		LEFT_TO_RIGHT
 *	treePacking 		TreePacking		ISOMORPHIC_PACKING
 *	connectionStyle		ConnectionStyle		DIAGONAL_CONNECTION
 *	nodeShape		NodeShape		False
 *	nodeSize		NodeSize		VARIABLE_SIZE
 *	resizePolicy		ResizePolicy		False
 *	horizontalSpace		Pad			15
 *	verticalSpace		Pad			5
 *	connectionSpace		ConnectionSpace		2
 *	foreground		Foreground		Black
 *	nodeForeground		Foreground		White
 *	nodeBackground		Background		Black
 *
 *	marginLeft		TreeMargin		2
 *	marginRight		TreeMargin		2
 *	marginTop		TreeMargin		2
 *	marginBottom		TreeMargin		2
 *
 *	minWidth		Dimension		0
 *	minHeight		Dimension		0
 *
 *	parentPlacement		ParentPlacement		PARENT_CENTERED
 *
 *	showRings		ShowRings		True
 *	ringForeground		Foreground		White
 *	ringBackground		Background		Black
 *	centerRootX		CenterRootX		True
 *	centerRootY		CenterRootY		False
 *
 */

#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif


#ifndef TREE_H
#define TREE_H

extern 		WidgetClass   		xpsiTreeWidgetClass;

typedef struct	_XpsiTreeClassRec	*XpsiTreeWidgetClass;
typedef struct 	_XpsiTreeRec		*XpsiTreeWidget;


/* ----------------------  Public functions  ---------------------- */

/* The following routine turns on/off the automatic layout when widgets
 * are managed/unmanaged. This is most useful when groups of
 * widgets are managed/unmanged. Turning on automatic layout forces one
 * layout. (Default is to do a layout for each managed/unmanaged widget)
 *
 * Example:
 *
 *		XpsiDoTreeLayout( tw, False );
 *		XtManageChildren( widgets, num_widgets );
 *		XpsiDoTreeLayout( tw, True );		   force layout 
 */

extern void XpsiDoTreeLayout();	 /* ( PsiTreeWidget tw, Boolean do_layout ) */

/* The following routine turns on/off the placement of unmanaged widgets
 * during the layout process.  (Default is False, i.e. unmanaged widgets
 * are ignored during layout.
 * 
 * Example:
 *
 *		XpsiLayoutUnmanaged( tw, True );
 */

extern void XpsiLayoutUnmanaged();

/* --------------------  Tree widget resources  ------------------- */

					/* --- Tree Orientation --- */

#define XtNtreeOrientation		"treeOrientation"
#define XtCTreeOrientation		"TreeOrientation"

#define XtRTreeOrientation		"TreeOrientation"

typedef unsigned int			TreeOrientation;

#define TOP_TO_BOTTOM			0
#define BOTTOM_TO_TOP   		1
#define LEFT_TO_RIGHT			2	/* Default */
#define RIGHT_TO_LEFT			3
#define STAR_TOPOLOGY   		4

					/* --- Tree Packing ---- */

#define XtNtreePacking			"treePacking"
#define XtCTreePacking			"TreePacking"

#define XtRTreePacking			"TreePacking"

typedef unsigned int			TreePacking;

#define ISOMORPHIC_PACKING		0	/* Default */
#define MINIMUM_WIDTH_PACKING		1

					/* --- Connection Style ---- */

#define XtNconnectionStyle		"connectionStyle"
#define XtCConnectionStyle		"ConnectionStyle"

#define XtRConnectionStyle		"ConnectionStyle"

typedef unsigned int			ConnectionStyle;

#define DIAGONAL_CONNECTION		0	/* Default */
#define TIER_CONNECTION			1
#define PATHWAY_CONNECTION		2
#define NO_CONNECTION			3

					/* ------ Node shape  ------ */

#define XtRNodeShape			"NodeShape"

typedef Boolean				 NodeShape;

#define XtNnodeShape			"nodeShape"
#define XtCNodeShape			"NodeShape"

					/* ------ Node size  ------- */

#define XtRNodeSize			"NodeSize"

typedef unsigned int			 NodeSize;

#define XtNnodeSize			"nodeSize"
#define XtCNodeSize			"NodeSize"

#define	VARIABLE_SIZE			0	/* Default */
#define FIXED_SIZE_FOR_LEVEL		1
#define FIXED_SIZE_FOR_TREE		2

					/* ---- Resize Policy ------ */

#define XtNresizePolicy			"resizePolicy"
#define XtCResizePolicy			"ResizePolicy"


					/* --- Internode Spacing --- */

#define XtNhorizontalSpace		"horizontalSpace"
#define XtNverticalSpace		"verticalSpace"
#define XtCPad				"Pad"

					/* --- Pathway Spacing ----- */

#define XtNconnectionSpace		"connectionSpace"
#define XtCConnectionSpace		"ConnectionSpace"

					/*-- Node Color -- */

#define XtNnodeForeground		"nodeForeground"
#define XtNnodeBackground		"nodeBackground"

					/* ------ Tree margins ----- */

#define XtNleftMargin			"leftMargin"
#define XtNrightMargin			"rightMargin"
#define XtNtopMargin			"topMargin"
#define XtNbottomMargin			"bottomMargin"
#define XtCTreeMargin			"TreeMargin"

typedef unsigned short			TreeMargin;

					/* -- Widget Minium  Size ---*/

#ifndef XtNminWidth
#define XtNminWidth "minWidth"		/* Sometimes defined in Xt/Shell.h  */
#define XtCMinWidth "MinWidth"
#endif

#ifndef XtNminHeight
#define XtNminHeight "minHeight"	/* Ditto to above */
#define XtCMinHeight "MinHeight"
#endif


					/* --- Parent Placement ---- */

#define XtNparentPlacement		"parentPlacement"
#define XtCParentPlacement		"ParentPlacement"

#define XtRParentPlacement		"ParentPlacement"

typedef unsigned int			ParentPlacement;

#define PARENT_CENTERED			0	/* Default */
#define PARENT_ABOVE_FIRST_CHILD	1
#define PARENT_ABOVE_LAST_CHILD		2


/* The remaining tree widget resources only apply to star topology
 * orientation
 */
					/* ------ Tree Rings  ------ */

#define XtNshowRings			"showRings"
#define XtCShowRings			"ShowRings"

					/* ------ Ring colors  ----- */

#define XtNringForeground		"ringForeground"
#define XtNringBackground		"ringBackground"

					/* ---- Center star on X --- */

#define XtNcenterRootX			"centerRootX"
#define XtCCenterRootX			"CenterRootX"

					/* ---- Center Star on Y  ---- */

#define XtNcenterRootY			"centerRootY"
#define XtCCenterRootY			"CenterRootY"

/* Constraint resources */

#define XtNparentWidget			"parentWidget"
#define XtCParentWidget			"ParentWidget"
#define XtNkey				"key"
#define XtCKey				"Key"
#define XtCBackgroundFill		"BackgroundFill"
#define XtNbackgroundFill		"backgroundFill"


/* Note the DrawShape and DrawConnection Resources are only
 * partially implemented. All they do now is NOT draw the 
 * shape if a routine is installed. Support will be added at
 * some point to allow drawing primitives to be returned from
 * the called function for inclusion in the tree's drawing list.
 */

/* We can override drawing of shapes on individual nodes.
 * the default is to use the tree's shape drawing mechanism.
 * A supplied routine does the drawing, if -1
 * no drawing is done.
 */

#define XtCDrawShapeFunc		"DrawShapeFunc"
#define XtNdrawShapeFunc		"drawShapeFunc"

#define NEVER_DRAW_SHAPE		-1

#define XtCDrawShapeFuncArg		"DrawShapeFuncArg"
#define XtNdrawShapeFuncArg		"drawShapeFuncArg"

/* We can install a custom connection drawing function
 * on a node by node basis. The default it to use the tree 
 * mechanism.
 */

#define XtCDrawConnectionFunc	"DrawConnectionFunc"
#define XtNdrawConnectionFunc	"drawConnectionFunc"

#define NEVER_DRAW_CONNECTION		-1

#define XtCDrawConnectionFuncArg	"DrawConnectionFuncArg"
#define XtNdrawConnectionFuncArg	"drawConnectionFuncArg"


#define XtCNumTreeNodeChildren	"NumTreeNodeChildren"
#define XtNnumTreeNodeChildren	"numTreeNodeChildren"



#define TREE_SUPER_ROOT			-1


#define XtNtreeResizeCallback		"treeResizeCallback"

#define XtNtreeResizeCallback		"treeResizeCallback"

typedef struct {
	int	reason;
	int	last_width;
	int	last_height;
	int	width;
	int	height;
} xpsiTreeCallbackStruct;

/* Reasons */

#define 	Xpsi_TREE_RESIZED	1



#endif 	/* TREE_H */
