/*
 * loadValues -  load Unixware process values
 *
 * Loads Unixware process values from
 *
 *      /proc/<pid> ...
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/times.h>
#include <sys/sysmacros.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <varargs.h>
#include <string.h>
#include <sys/param.h>          /* To get PAGESIZE i.e. system page      */
#include <dirent.h>             /* To get the /proc directory listing    */

#include <Xm/Xm.h>

#include <Xpsi/Tree.h>  /* Custom Tree widget */

#include "tree.h"       /* Generic m-ary tree package include file */
#include "list.h"       /* Simple list package                     */
#include "debug.h"      /* Macro based debug package               */

#include "button_bar.h"

#include "user_group.h" /* User_group display related definitions  */

#include "treeps.h"


#ifndef NULL_CHAR
#define NULL_CHAR (char) 0
#endif

extern size_t PageSize;         /* From treeps.c */

int 	
load_sys_proc_info( pid, pli_ptr )
int   pid;
Process_list_info  *pli_ptr;
{
	char		proc_path[64];
	char		proc_info[64];
	int 		fd;
	int		rc;
	struct  stat    s;

	/* sprintf( proc_dir, "/proc/%d", pid ); */

	sprintf( proc_path, "%s/%d", PROCESS_INFO_DIRECTORY, pid );

	/* We call stat to see if we have access and to determine
	 * the effective uid/gid  of the process. 
	 *
	 */

	rc = stat( proc_path, &s );   
	if ( rc == -1 )
	{
		if ( Debug > 0 )
			perror("load_sys_proc_info: stat");
	 	DEBUG1(1,"load_sys_proc_info:can't stat %s\n", proc_path );
	 	return( IGNORE_PROCESS );
	}

	if ( pli_ptr == NULL )
	{
	 	DEBUG1(1,"load_sys_proc_info: null pli_ptr for %d\n", pid );
		return( IGNORE_PROCESS );
	}

	if ( pli_ptr->pp == NULL)
	{
	 	DEBUG1(1,"load_sys_proc_info: null pp for %d\n", pid );
		return( IGNORE_PROCESS );
	}

	PROCESS_EFFECTIVE_USER_ID( pli_ptr )  = (int )s.st_uid;
	PROCESS_EFFECTIVE_GROUP_ID( pli_ptr ) = (int )s.st_gid;

#ifdef SVR4_MP
	sprintf( proc_info, "%s/psinfo", proc_path, pid );
#else
	sprintf( proc_info, "%s", proc_path );
#endif

	fd = open( proc_info, O_RDONLY );
	if ( fd == -1 )
	{
		DEBUG1(1,"load_sys_proc_info: open failed (%s)\n", proc_info);
		if ( debug > 0 )
			perror("open /proc info file");
		return( IGNORE_PROCESS );
	}

#ifdef SVR4_MP
    	rc = read(fd, pli_ptr->pp, sizeof( sysProcInfo ) );
	if ( rc < sizeof( sysProcInfo ) )
#else
	rc = ioctl(fd, PIOCPSINFO, pli_ptr->pp);
	if ( rc == -1 )
#endif
	{
		if ( Debug > 0 )
		{
		   fprintf( stderr,"Incomplete read/stat(pid)!!! rc(%d)(%d)\n",
							pid,
                                                        rc,
                                                        sizeof(sysProcInfo));
				perror("load_sys_proc_info: read/stat");
                }

		close( fd );
		return( IGNORE_PROCESS );
	}

	DEBUG3( 9, "load_sys_proc_info: pid(%d) ppid(%d) cmd(%s)\n",
				pli_ptr->pp->pr_pid, 
				pli_ptr->pp->pr_ppid, 
				pli_ptr->pp->pr_fname );

	close( fd ); 	/* Close the process file */

	return( ADD_PROCESS );
}

