/* 
 * details -  display more process details
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/times.h>
#include <sys/sysmacros.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <varargs.h>
#include <string.h>
#include <sys/param.h>          /* To get PAGESIZE i.e. system page      */
#include <dirent.h>             /* To get the /proc directory listing    */
#include <errno.h>

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>


#include "tree.h"       /* Generic m-ary tree package include file */
#include "list.h"       /* Simple list package                     */
#include "debug.h"      /* Macro based debug package               */

#include <Xpsi/Tree.h>

#include "button_bar.h"
#include "user_group.h" /* User_group display related definitions  */

#include "os_info.h"

#include "treeps.h"


#ifndef NULL_CHAR
#define NULL_CHAR (char) 0
#endif

#include "SysCalls"

extern size_t PageSize;		/* From treeps.c */

void do_statusInfo();
void do_credentialInfo();
void do_memInfo();
void do_signalInfo();
void do_objectInfo();
void do_LWPinfo();
void do_LWPstat();
void do_Info();
Widget do_detailPopup();

typedef struct _objectToName
{
	char  *object;
	char  *name;
} ObjectToName;

lnode *getObjectInfoList();
lnode *addObjectName_toList();
char  *findObjectsName();


static void
initializeDetails()
{
	/* Don't know when this was introduced, this is a guess */

	if ( osMajorReleaseNumber > 1  && osMinorReleaseNumber > 1 )
	{
		;
	}
}

Widget
detailsPanel( parent, attachto, pid, pName )
Widget parent;
Widget attachto;
int pid;
char *pName;
{
	Widget w;
	int n;
	Arg wargs[12];
	static int first=1;

	if ( first )
	{
		initializeDetails();
		first = 0;
	}

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 4); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 24); n++;
        w = XtCreateManagedWidget("Sig Info", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_signalInfo, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 28); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 48); n++;
        w = XtCreateManagedWidget("Object", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_objectInfo, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 52); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 72); n++;
        w = XtCreateManagedWidget("All LWP Stat", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_LWPstat, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 76); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 96); n++;
        w = XtCreateManagedWidget("All LWP Info", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_LWPinfo, 
						   (XtPointer) pid );

	attachto = w;

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 4); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 24); n++;
        w = XtCreateManagedWidget("Info +1 lwp", xmPushButtonWidgetClass,
                                                parent, wargs, n );


        XtAddCallback( w, XmNactivateCallback, do_Info, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 28); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 48); n++;
	/* XtSetArg( wargs[n], XmNuserData, ( XtPointer ) strdup( pName )); n++; */
        w = XtCreateManagedWidget("Stat +1 LWP", xmPushButtonWidgetClass,
                                                parent, wargs, n );


        XtAddCallback( w, XmNactivateCallback, do_statusInfo, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 52 ); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 72 ); n++;
        w = XtCreateManagedWidget("Cred", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_credentialInfo, 
						   (XtPointer) pid );

 	n = 0;
        XtSetArg( wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
        XtSetArg( wargs[n], XmNbottomWidget, attachto); n++;
        XtSetArg( wargs[n], XmNbottomOffset, 2); n++;
        XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNleftPosition, 76); n++;
        XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_POSITION); n++;
        XtSetArg( wargs[n], XmNrightPosition, 96); n++;
        w = XtCreateManagedWidget("Mem Maps", xmPushButtonWidgetClass,
                                                parent, wargs, n );

        XtAddCallback( w, XmNactivateCallback, do_memInfo, 
						   (XtPointer) pid );

	return( w );
}


#define MAX_FILE_INFO 20000  /* SWAG */
#define MAX_PATH 256

#define P       pos += sprintf( &(buf[pos]), 


void
do_statusInfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	char 		path[MAX_PATH];
	char		dialogLabel[128];
        pstatus_t 	s;
	int 		i, pos, rc, fd;
	Arg 		wargs[3];
	char 		buf[MAX_FILE_INFO];
	char		*c;


	sprintf( path, "%s/%d/status", PROCESS_INFO_DIRECTORY, pid );

	pos = 0;

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    P "ERROR: Can't open process status file:%s!!!\n\n%s\n", 
					path, strerror( errno ));
        }
	else
	{
            rc = read(fd, &s, sizeof( pstatus_t ) );
            if ( rc < sizeof( pstatus_t ) )
            {
	        P "ERROR: Failed to read process status structure!!!\n" );
            }
	    else
	    {
		P "For details on fields see man proc(4) and files:\n\n");
		P "\t/usr/include/sys/procfs.h\n" );
		P "\t/usr/include/sys/signal.h\n" );
		P "\t/usr/include/sys/fault.h\n" );
		P "\t/usr/include/sys/syscall.h\n" );
		P "\n" );

		P "Flags:\t\t 0x%lX\n", s.pr_flags );
		P "Nlwp:\t\t %d\n", s.pr_nlwp );

		#define A s.pr_sigpend.sa_sigbits

		P "sigpend:\t [0x%8.8lX] [0x%8.8lX] [0x%8.8lX] [0x%8.8lX]\n",A[0],A[1],A[2],A[3]);

		P "Heap start:\t 0x%8.8lX (%lu)\n", s.pr_brkbase, s.pr_brkbase );
		P "Heap size:\t %d bytes\n", s.pr_brksize );

		P "Stack Start:\t 0x%8.8lX (%lu)\n", s.pr_stkbase, s.pr_stkbase );
		P "Stack size:\t %d bytes\n", s.pr_stksize );

		P "PID:\t\t %d\n", s.pr_pid );
		P "PPID:\t\t %d \t\t- Parent PID\n", s.pr_ppid );
		P "PGID:\t\t %d \t\t- Group Leader PID\n", s.pr_pgid );
		P "PSID:\t\t %d \t\t- Session Leader PID\n", s.pr_sid );

		P "utime:\t\t %lu.%9.9lu sec\n", s.pr_utime.tv_sec, s.pr_utime.tv_nsec );
		P "stime:\t\t %lu.%9.9lu sec\n", s.pr_stime.tv_sec, s.pr_stime.tv_nsec );

		c = " - Cummulative User Time";
		P "cutime:\t\t %lu.%9.9lu sec %s\n", s.pr_cutime.tv_sec, s.pr_cutime.tv_nsec,c);

		c = " - Cummulative System Time";
		P "cstime:\t\t %lu.%9.9lu sec %s\n", s.pr_cstime.tv_sec, s.pr_cstime.tv_nsec,c);

		#define B s.pr_sigtrace.sa_sigbits

		P "sigtrace:\t [0x%8.8lX] [0x%8.8lX] [0x%8.8lX] [0x%8.8lX]\n",B[0],B[1],B[2],B[3]);

		#define C s.pr_flttrace.word

		P "flttrace:\t [0x%8.8X] [0x%8.8X] [0x%8.8X] [0x%8.8X]\n",C[0],C[1],C[2],C[3]);

		P "sysentry:\t " );
		for ( i = 0; i < 16;  i++  )
		{
			if ( i == 8 ) P "\n\t\t " );
			P "[0x%8.8lX] ", s.pr_sysentry.word[i] );
		}

		P "\nsysexit:\t " );
		for ( i = 0; i < 16;  i++  )
		{
			if ( i == 8 ) P "\n\t\t " );
			P "[0x%8.8lX] ", s.pr_sysexit.word[i] );
		}

		/* LWP */

		P "\n\nRepresentative Task(LWP)\n\n");

		pos += printLWPstatus( buf, pos, &s.pr_lwp );
	    }

            close( fd );    /* Close the process file */
	}

	pos = strlen( buf );

	sprintf( dialogLabel, "Process Status Info for pid(%d)", pid );

	do_detailPopup( w, dialogLabel, 50, 120, False, buf );
}

int
printLWPstatus( buf, pos, s )
char *buf;
int pos;
lwpstatus_t *s;
{
	int i;

	P "Flags:\t\t 0x%lX\n", s->pr_flags );
	P "why:\t\t 0x%hX\n", s->pr_why );
	P "what:\t\t 0x%hX\n", s->pr_what );
	P "lwpid:\t\t %d\n", s->pr_lwpid );
	P "cursig:\t\t %hd\n", s->pr_cursig );

	#define D s->pr_lwppend.sa_sigbits

	P "lwppend:\t [0x%8.8lX] [0x%8.8lX] [0x%8.8lX] [0x%8.8lX]\n",D[0],D[1],D[2],D[3]);

	P "siginfo:\t signo(%d), code(%d), errno(%d)\n", 
				s->pr_info.si_signo,
				s->pr_info.si_code,
				s->pr_info.si_errno );  /* Skip rest of details */

	P "altstack:\t ss_sp(0x%x) size(%d) flags(0X%X)\n",
				((char ) s->pr_altstack.ss_sp),
				((int ) s->pr_altstack.ss_size),
				s->pr_altstack.ss_flags ); 

	P "action:\t\t flags(0X%X) \n", s->pr_action.sa_flags );
		
	#define E s->pr_action.sa_mask.sa_sigbits

	P "action:\t\t [0x%8.8lX] [0x%8.8lX] [0x%8.8lX] [0x%8.8lX]\n",E[0],E[1],E[2],E[3]);

	if ( (s->pr_syscall > 0)  &&  ( s->pr_syscall < 235 ))
	{
		P "syscall:\t %hd - %s\n", s->pr_syscall,
					sysCallStr[s->pr_syscall] );
	}
	else
	    P "syscall:\t %hd\n", s->pr_syscall );

	P "nsysarg:\t %hd\n", s->pr_nsysarg );

	P "sysarg:\t\t " );
	for ( i = 0 ; i < s->pr_nsysarg; i++ )
	{
		P "[%d] = 0X%X ", i, s->pr_sysarg[i] );
	}
	P "\n" );

	P "clname:\t\t %s\n", s->pr_clname );
	P "instr:\t\t %ld\n", s->pr_instr );

	P "context:\t not supported yet.\n"  );

	P "family:\t\t flags(0x%X) \n\tdb_reg = ",  s->pr_family.pf_flags );

	for ( i = 0 ; i < NDEBUGREG ; i++ )
	{
		P "[0x%8.8lX] ", s->pr_family.pf_dbreg.debugreg[i] );
	}

	return pos;
}


getFileTime( ft, buf )
time_t ft;
char *buf;
{
  	struct tm *t;
	char      *month;

  	t = localtime( &ft );
	if ( t == NULL )
		return;

	switch( t->tm_mon ) {
	    case  0: month = "Jan"; break;
	    case  1: month = "Feb"; break;
	    case  2: month = "Mar"; break;
	    case  3: month = "Apr"; break;
	    case  4: month = "May"; break;
	    case  5: month = "Jun"; break;
	    case  6: month = "Jul"; break;
	    case  7: month = "Aug"; break;
	    case  8: month = "Sep"; break;
	    case  9: month = "Oct"; break;
	    case 10: month = "Nov"; break;
	    case 11: month = "Dec"; break;

	    default: month = "XXX"; break;
	}

	sprintf( buf, "%s %2d %4d %02d:%02d", month, t->tm_mday, 
			t->tm_year + 1900, t->tm_hour, t->tm_min );
}

getPermStr( m, buf )
int m;
char *buf;
{
	char t, ur,uw,ux,gr,gw,gx,ar,aw,ax;

	if ( S_ISLNK(m) ) 		t = 'l';
	else if ( S_ISDIR(m) )		t = 'd';
	else if ( S_ISREG(m) )		t = '-';
	else if ( S_ISCHR(m) )		t = 'c';
	else if ( S_ISBLK(m) )		t = 'b';
	else if ( S_ISFIFO(m) )		t = 'p';
	else if ( S_ISSOCK(m) )		t = 's';

	t = ( m & S_ISVTX ) ? 'S' : t;		/* Sticky bit */

	ur = ( m & S_IRUSR ) ? 'r' : '-';
	uw = ( m & S_IWUSR ) ? 'w' : '-';
	ux = ( m & S_IXUSR ) ? 'x' : '-';
	ux = ( m & S_ISUID ) ? 's' : ux;	/* Set UID */

	gr = ( m & S_IRGRP ) ? 'r' : '-';
	gw = ( m & S_IWGRP ) ? 'w' : '-';
	gx = ( m & S_IXGRP ) ? 'x' : '-';
	gx = ( m & S_ISGID ) ? 's' : gx;	/* Set GID */

	ar = ( m & S_IROTH ) ? 'r' : '-';
	aw = ( m & S_IWOTH ) ? 'w' : '-';
	ax = ( m & S_IXOTH ) ? 'x' : '-';

	buf[0] = t;
	buf[1] = ur; buf[2] = uw; buf[3] = ux;
	buf[4] = gr; buf[5] = gw; buf[6] = gx;
	buf[7] = ar; buf[8] = aw; buf[9] = ax;
	buf[10] = (char) 0;
}

#define MAX_CRED 10000

void
do_credentialInfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		len, i, pos, rc, fd;
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
	gid_t		gid;
        prcred_t 	s;
	char		buf[MAX_CRED];  /* A guess, we truncate to max */


	sprintf( path, "%s/%d/cred", PROCESS_INFO_DIRECTORY, pid );

	pos = 0;

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    sprintf( buf, "ERROR: Can't open process status file!!!\n\n%s\n", 
					strerror( errno ));
        }
	else
	{
            rc = read(fd, &s, sizeof( prcred_t ) );
            if ( rc < sizeof( prcred_t ) )
            {
	        sprintf( buf, "ERROR: Failed to read process credential structure!!!\n" );
            }
	    else
	    {
		P "For details on fields see man proc(4) and files:\n\n");
		P "\t/usr/include/sys/procfs.h\n" );
		P "\n" );

		P "euid:\t\t %d\n", s.pr_euid );
		P "ruid:\t\t %d\n", s.pr_ruid );
		P "suid:\t\t %d\n", s.pr_suid );
		P "egid:\t\t %d\n", s.pr_egid );
		P "rgid:\t\t %d\n", s.pr_rgid );
		P "sgid:\t\t %d\n", s.pr_sgid );

		P "ngroups:\t %d\n", s.pr_ngroups );

		P "groups:\t\t ");

		if ( s.pr_ngroups > 0 )
			P "%d ", s.pr_groups[0]);

		if ( s.pr_ngroups > 1 )
		{
		  for ( i = 0 ; i < (s.pr_ngroups-1); i++ )
		  {
            	    rc = read(fd, &gid, sizeof( gid_t ) );
            	    if ( rc < sizeof( gid_t ) )
            	    {
	        	P "ERROR: Failed to read credential supplemental group!!!\n" );
            	    }
		    else
		    {
		    	P "%d ", gid);
		    }
		  }
		}
	    }
	}

	pos = strlen( buf );

	sprintf( dialogTitle, "Credentials for pid(%d)", pid);

	do_detailPopup( w, dialogTitle, 14, 50, False, buf);
}

#define MAX_MAPINFO 40000	/* A WAG */

void
do_memInfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		len, i, pos, rc, fd;
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
	char		c;
	gid_t		gid;
        prmap_t 	s;
	int		notDone=1;
	int		first=1;
	char		buf[MAX_MAPINFO];  /* A guess, we truncate to max */
	lnode		*head;
	char		*actualName;


	sprintf( path, "%s/%d/map", PROCESS_INFO_DIRECTORY, pid );

	pos = 0;

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    P "ERROR: Can't open process memory map file!!!\n\n%s\n", 
					strerror( errno ));
        }
	else
	{
	  head = getObjectInfoList( pid );

	  while ( notDone )
	  {
            rc = read(fd, &s, sizeof( prmap_t ) );
            if ( rc < sizeof( prmap_t ) )
            {
		if ( first )
		{
	            P "ERROR: Failed to read process memory map structure!!!\n" );
		}
		notDone = 0;
            }
	    else
	    {
		if ( first )
		{
		  P "For details on fields see man proc(4) and files:\n\n");
		  P "\t/usr/include/sys/procfs.h\n" );
		  P "\n" );
		  P " Virtual Address     size     Offset   Perm           Name \n");
		  P "=================  ========  ========  =====  =======================\n\n");
		}

		P "%8.8lX-%8.8lX ", s.pr_vaddr, s.pr_vaddr + s.pr_size );
		P "%9lu ", s.pr_size );
		P " %8.8lX  ", s.pr_off );

		if ( s.pr_mflags & MA_BREAK ) c = 'B';
		else if ( s.pr_mflags & MA_STACK ) c = 'S';
		else c = ' ';

		P "%c", c );

		c = s.pr_mflags & MA_SHARED ? 'H': ' '; P "%c", c );
		c = s.pr_mflags & MA_READ   ? 'r': '-'; P "%c", c );
		c = s.pr_mflags & MA_WRITE  ? 'w': '-'; P "%c", c );
		c = s.pr_mflags & MA_EXEC   ? 'x': '-'; P "%c", c );

		actualName = findObjectsName( head, s.pr_mapname );

		if ( strcmp( actualName, " " ) == 0 )
		    P "  %s", s.pr_mapname );
		else
		    P "  %s  - %s", s.pr_mapname, actualName );

		P "\n" );
	    }
	    first = 0;
	  }

	  free_objectToNameList( head );

	}

	P "\n\n" );

	P "B - Grown by brk(2)\n" );
	P "S - Grown Automatically by Stack Faults\n" );
	P "H - Changes are sHared by mapped object\n" );

	P "\n\n Run the following command to see what the named objects are\n\n" );
	P "dump -p -T 1 /proc/$pid/object/* \n" );

	pos = strlen( buf );

        sprintf( dialogTitle, "Memory Map Info for pid(%d)", pid );

	do_detailPopup( w, dialogTitle, 30, 100, False, buf );
}


void
do_signalInfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		len, i, pos, rc, fd;
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
	char		*str;
	gid_t		gid;
        struct sigaction s;
	int		notDone=1;
	char		buf[MAX_MAPINFO];  /* A guess, we truncate to max */


	sprintf( path, "%s/%d/sigact", PROCESS_INFO_DIRECTORY, pid );

	pos = 0;

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    P "ERROR: Can't open process signal action file!!!\n\n%s\n", 
					strerror( errno ));
        }
	else
	{
	  i = 0;
	  while ( notDone )
	  {
            rc = read(fd, &s, sizeof( struct sigaction ) );
            if ( rc < sizeof( struct sigaction ) )
            {
		if ( i == 0 )
		{
	            P "ERROR: Failed to read process signal action structure!!!\n" );
		}
		notDone = 0;
            }
	    else
	    {
		if ( i == 0 )
		{
		  P "For details on fields see man proc(4) and files:\n\n");
		  P "\t/usr/include/sys/procfs.h\n" );
		  P "\n" );
		  P " Sig                          Mask                                  Flags \n");
		  P "=====  ============ ============ ============ ============  =====================\n\n");
		}

		P "  %2d   ", i );

		#define F s.sa_mask.sa_sigbits

		P "[0x%8.8lX] [0x%8.8lX] [0x%8.8lX] [0x%8.8lX]",F[0],F[1],F[2],F[3]);

		P "  " );

		str = s.sa_flags & SIGDEFER  ? "DEFER":   ""; P "%s,", str );
		str = s.sa_flags & SIGHOLD   ? "HOLD":    ""; P "%s,", str );
		str = s.sa_flags & SIGRELSE  ? "RELEASE": ""; P "%s,", str );
		str = s.sa_flags & SIGIGNORE ? "IGNORE":  ""; P "%s,", str );
		str = s.sa_flags & SIGPAUSE  ? "PAUSE":   ""; P "%s,", str );

		P "\n" );

	     }
	     i++;
	  }
	}

	pos = strlen( buf );

	sprintf( dialogTitle, "Signal Details for pid(%d)", pid );
	do_detailPopup( w, dialogTitle, 42, 90, False, buf );
}

#define MAX_OBJECT_INFO 20000

#define IN_BUF_SIZE 256
#define CMD_BUF_SIZE 256

void
do_objectInfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		pos;
	lnode		*head, *ptr;
	ObjectToName	*o;
	char    	dialogTitle[128];
	char 		buf[MAX_OBJECT_INFO];

	head = getObjectInfoList( pid );

	pos   = 0;

	P "For details on fields see man proc(4) and files:\n\n");
	P "\t/usr/include/sys/procfs.h\n" );
	P "\n" );


	for ( ptr = head ; ptr != NULL_LNODE_PTR; ptr = ptr->next )
	{
	   o = ( ObjectToName *)ptr->data;

	   P "%s:\t %s\n", o->object, o->name );

	   if ( pos > (MAX_OBJECT_INFO - 1000) )
	   {
		P "\n\nToo many objects for text buffer!!!! Increase MAX_OBJECT_INFO\n" );
		break;
	   }
	}

	pos = strlen( buf );

	sprintf( dialogTitle, "Object Details for pid(%d)", pid );
	do_detailPopup( w, dialogTitle, 25, 80, False, buf );

	free_objectToNameList( head );
}

lnode *
getObjectInfoList( pid )
int pid;
{
	int 		i, rc, len, fd;
	char 		path[MAX_PATH];
	DIR 		*dirp;		/* Directory ptr, opened  once */
	struct  dirent 	*direntp;
	char		*fname, *str;
	char		inBuf[IN_BUF_SIZE];
	char		cmd[CMD_BUF_SIZE];
	FILE		*fp;
	lnode		*head=NULL;

	sprintf( path, "%s/%d/object", PROCESS_INFO_DIRECTORY, pid );

	dirp = opendir( path );
	if ( dirp == NULL )
	{
		return( NULL );
	}
	else
	{
	 while ( (direntp = readdir( dirp )) != NULL )
	 {

	  fname = direntp->d_name;

	  if ( 	( fname[0] == '.' ) &&   /* Skip . */
		( fname[1] == NULL_CHAR ))
	  {
		continue;
	  }

	  if ( 	( fname[0] == '.' ) &&   /* Skip .. */
		( fname[1] == '.' ) &&
		( fname[2] == NULL_CHAR ))
	  {
		continue;
	  }
		
	  if ( strcmp( fname, "a.out" ) == 0 )
	  {
		head = addObjectName_toList( head, fname, "a.out" );
	  }
	  else /* print info about object */
	  {
	    sprintf( path, "%s/%d/object/%s", PROCESS_INFO_DIRECTORY, pid, fname );
	    sprintf( cmd, "/bin/dump -p -T 1 %s 2>/dev/null | /bin/awk '/\\[1/{print $8}'", path );

            fp = popen( cmd, "r" );
            if ( fp == NULL )
            {
		head = addObjectName_toList( head, fname, "<fetch error>" );
            }
	    else
	    {
                str = fgets( &(inBuf[0]), IN_BUF_SIZE - 5, fp );
                if ( str == NULL )
                {
		    head = addObjectName_toList( head, fname, " " );
                }
	        else
	        {
		  len = strlen( inBuf );

		  if ( strlen(inBuf) > 250 )
		      inBuf[250] = '\0';
		  else
		  {
			inBuf[len-1] = '\0';
		  }
		  
		  head = addObjectName_toList( head, fname, inBuf );
	        }

	        pclose( fp );
	    }
	  }
	 } /* End while loop */
	}

	if ( dirp ) closedir( dirp );

	return head;
}

lnode *
addObjectName_toList( head, object, name )
lnode *head;
char  *object;
char  *name;
{
	lnode        *new_head;
	ObjectToName *o;
	static int key=1;

	o = (ObjectToName *)malloc( sizeof( ObjectToName ) );
	if ( o == NULL ) return head;

	if ( object == NULL ) object = "";
	if ( name == NULL ) name = "";

	o->object = strdup( object );
	o->name   = strdup( name );

	new_head = fwd_insert_lnode( head, key++, (void *) o );

	return new_head;
}

free_objectToNameList( head )
lnode *head;
{
	lnode *ptr, *next_ptr;
	ObjectToName *o;

	for ( ptr = head ; ptr != NULL_LNODE_PTR; ptr = next_ptr )
	{
		o = ( ObjectToName *)ptr->data;

		if ( o->object ) free( o->object );
		if ( o->name )   free( o->name );

		next_ptr = ptr->next;
		destroy_lnode( ptr );
	}
}

char
*findObjectsName( head, object )
lnode *head;
char  *object;
{
	lnode *ptr;
	ObjectToName *o;

	for ( ptr = head ; ptr != NULL_LNODE_PTR; ptr = ptr->next )
	{
		o = ( ObjectToName *)ptr->data;

		if ( strcmp( object, o->object ) == 0 )
			return( o->name );
	}

	return( " " );
}


#define MAX_LWP_INFO 40000

void
do_LWPinfo( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		first, ms_sec, len, i, pos, rc, fd, lwpid;
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
        lwpsinfo_t 	f;
	DIR 		*dirp;		/* Directory ptr, opened  once */
	struct  dirent 	*direntp;
	char		*e;		/* End of number in file name */
	char		*fname;
	char		buf[MAX_LWP_INFO];  /* A guess, we truncate to max */


	sprintf( path, "%s/%d/lwp", PROCESS_INFO_DIRECTORY, pid );

	pos   = 0;
	first = 1;

	dirp = opendir( path );
	if ( dirp == NULL )
	{
	    P "ERROR: Can't open processes lwp directory: %s !!!\n\n%s\n", 
					path,
					strerror( errno ));
	}
	else
	{
	 while ( (direntp = readdir( dirp )) != NULL )
	 {

	  fname = direntp->d_name;

	  if ( 	( fname[0] == '.' ) &&   /* Skip . */
		( fname[1] == NULL_CHAR ))
	  {
		continue;
	  }

	  if ( 	( fname[0] == '.' ) &&   /* Skip .. */
		( fname[1] == '.' ) &&
		( fname[2] == NULL_CHAR ))
	  {
		continue;
	  }
		
	  /* If not a number, then skip it. Just in case
	   * there are some non numeric directories/files in the directory
	   */

	  lwpid = strtol( fname, &e, 10 );
	  if ( e == fname )
	  {
		continue;		/* not a number */
	  }

	  /* print info for lwpid */

	  if ( first )
	  {
	    P "For details on fields see man proc(4) and files:\n\n");
	    P "\t/usr/include/sys/procfs.h\n" );
	    P "\n" );

P "LWPID  S  Class   State Stype PRI NI   ADDR     WCHAN   FLAGS   ON BND ExB      TIME      Name\n");
P "=====  = ======== ===== ===== === == ======== ======== ======== == === ===  ============ =======");
	    P "\n" );
	    first = 0;
	  }

	  sprintf( path, "%s/%d/lwp/%d/lwpsinfo", PROCESS_INFO_DIRECTORY, pid, lwpid );

          fd = open( path, O_RDONLY );
          if ( fd == -1 )
          {
	    P "ERROR: Can't open LWP info file: %s!!!\n\n%s\n", path,
					strerror( errno ));
          }
	  else
	  {
              rc = read(fd, &f, sizeof( lwpsinfo_t ) );
              if ( rc < sizeof( lwpsinfo_t ) )
              {
	            P "ERROR: Failed to read light weight process info for lwpid(%d)!!!\n", lwpid );
              }
	      else
	      {
		P "%5d  ", f.pr_lwpid );
		P "%c ", f.pr_sname );
		P "%8s ", f.pr_clname );
		P "%5d ", (int) f.pr_state );
		P "%5d ", (int ) f.pr_stype );

		P "%3d", f.pr_pri );
		P "%3d ", (int) f.pr_nice );

		P "%8.8x ", f.pr_addr );
		P "%8.8x ", f.pr_wchan );
		P "%8lx ", f.pr_flag );

		P "%2d ", f.pr_onpro );
		P "%3d ", f.pr_bindpro );
		P "%3d ", f.pr_exbindpro );

		ms_sec = f.pr_time.tv_nsec == 0 ? 0 : f.pr_time.tv_nsec / 1000000;

		P "%9lu.%3.3d ", f.pr_time.tv_sec, ms_sec );

		P "%s\n", f.pr_name );
	      }

	      close( fd );
	  }


	  if ( pos > (MAX_LWP_INFO - 5000) )
	  {
		P "\n\nToo many threads for text buffer!!!! Increase MAX_LWP_INFO\n" );
		break;
	  }
	 }

	}

	if ( dirp ) closedir( dirp );


	pos = strlen( buf );

	sprintf( dialogTitle, "Light Weight Process Details for pid(%d)", pid );
	do_detailPopup( w, dialogTitle, 25, 120, False, buf );
}

void
do_oneLWP( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		ms_sec, len, i, n, pos, rc, fd, lwpid;
	Arg		wargs[16];
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
        lwpsinfo_t 	f;
	char		buf[MAX_LWP_INFO];  /* A guess, we truncate to max */

	sprintf( path, "%s/%d/lwp", PROCESS_INFO_DIRECTORY, pid );

	pos   = 0;
	lwpid = -1;

	
	P "For details on fields see man proc(4) and files:\n\n");
	P "\t/usr/include/sys/procfs.h\n" );
	P "\n" );

	
	n = 0;
	XtSetArg( wargs[n], XtNkey, &lwpid ); n++;
	XtGetValues( w, wargs, n );

	if ( lwpid < 0 )
		lwpid = lwpid + 100000;
	if ( lwpid >= 10000 )
		lwpid = lwpid - 100000;

	sprintf( path, "%s/%d/lwp/%d/lwpsinfo", PROCESS_INFO_DIRECTORY, pid, lwpid );

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    P "ERROR: Can't open LWP info file: %s!!!\n\n%s\n", path,
					strerror( errno ));
        }
	else
	{
              rc = read(fd, &f, sizeof( lwpsinfo_t ) );
              if ( rc < sizeof( lwpsinfo_t ) )
              {
	            P "ERROR: Failed to read light weight process info for lwpid(%d)!!!\n", lwpid );
              }
	      else
	      {
		P "LWPID:\t\t %d\n", f.pr_lwpid );
		P "Name:\t\t %s\n", f.pr_name );
		P "Addr:\t\t %8.8x\t - %s\n", f.pr_addr, "Internal Address of LWP" );
		P "Wchan:\t\t %8.8x\t - %s\n", f.pr_wchan, "Wait Addr for Sleeping LWP" );
		P "Flags:\t\t %8.8lx\n", f.pr_flag );

		P "Sname:\t\t %c\t\t - %s\n", f.pr_sname, "Run State: O - Running, S - Sleeping ...  see ps(1)" );
		P "Stype:\t\t %d\t\t - %s\n", (int ) f.pr_stype, "Synchronization Event Type"  );

		P "Class:\t\t %s\t\t - %s\n", f.pr_clname, "Scheduling Class" );
		P "State:\t\t %d\t\t - %s\n", (int) f.pr_state, "Numeric scheduling state" );
		P "Priority:\t %d\n", f.pr_pri );
		P "Nice:\t\t %d\n", (int) f.pr_nice );


		P "Onpro:\t\t %d\t\t - %s\n", f.pr_onpro, "Processor on which LWP is running" );
		P "Bind:\t\t %d\t\t - %s\n", f.pr_bindpro, "Processor to which LWP is bound" );
		P "exbind:\t\t %d\t\t - %s\n", f.pr_exbindpro, "Processor to which LWP is exbound" );

		ms_sec = f.pr_time.tv_nsec == 0 ? 0 : f.pr_time.tv_nsec / 1000000;

		P "Time:\t\t %lu.%3.3d\t\t - %s\n", f.pr_time.tv_sec, 
						ms_sec, "usr+sys cpu time for this LWP" );
	      }
	      close( fd );
	}

	P "\nNote: LWP are not fully implemented yet. In particular they:\n");
	P "\n");
	P "\tHave no dynamic fetching of their values.\n");
	P "\tHave have just one action(info), no select/signal/kill/outline/hide actions.\n");
	P "\tHave no decorations.\n");
	P "\tHave no color coding.\n");
	P "\tCannot have any values extracted to the main tree.\n");
	P "\tHave no LWP Tips.\n");
	P "\tHave no popup menu.\n");
	P "\tHave no user filters - they are either displayed or not.\n");
	P "\n");
	P "These will be added at a future date.\n");

	pos = strlen( buf );

	sprintf( dialogTitle, "Light Weight Process Details for pid(%d) LWP(%d)", pid, lwpid );
	do_detailPopup( w, dialogTitle, 31, 88, False, buf );
}

void
do_LWPstat( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	int 		first, len, i, pos, rc, fd, lwpid;
	char 		path[MAX_PATH];
	char    	dialogTitle[128];
	char		*str;
	gid_t		gid;
        lwpstatus_t 	s;
        lwpsinfo_t 	f;
	DIR 		*dirp;		/* Directory ptr, opened  once */
	struct  dirent 	*direntp;
	char		*e;		/* End of number in file name */
	char		*fname;
	int		notDone=1;
	char		buf[MAX_LWP_INFO];  /* A guess, we truncate to max */


	sprintf( path, "%s/%d/lwp", PROCESS_INFO_DIRECTORY, pid );

	pos   = 0;
	first = 1;

	dirp = opendir( path );
	if ( dirp == NULL )
	{
	    P "ERROR: Can't open processes lwp directory: %s !!!\n\n%s\n", 
					path,
					strerror( errno ));
	}
	else
	{
	 while ( (direntp = readdir( dirp )) != NULL )
	 {

	  fname = direntp->d_name;

	  if ( 	( fname[0] == '.' ) &&   /* Skip . */
		( fname[1] == NULL_CHAR ))
	  {
		continue;
	  }

	  if ( 	( fname[0] == '.' ) &&   /* Skip .. */
		( fname[1] == '.' ) &&
		( fname[2] == NULL_CHAR ))
	  {
		continue;
	  }
		
	  /* If not a number, then skip it. Just in case
	   * there are some non numeric directories/files in the directory
	   */

	  lwpid = strtol( fname, &e, 10 );
	  if ( e == fname )
	  {
		continue;		/* not a number */
	  }

	  /* print info for lwpid */

	  if ( first )
	  {
	    P "For details on fields see man proc(4) and files:\n\n");
	    P "\t/usr/include/sys/procfs.h\n" );
	    P "\n" );

	    first = 0;
	  }

	  sprintf( path, "%s/%d/lwp/%d/lwpstatus", PROCESS_INFO_DIRECTORY, pid, lwpid );

          fd = open( path, O_RDONLY );
          if ( fd == -1 )
          {
	    P "ERROR: Can't open LWP status file: %s!!!\n\n%s\n", path,
					strerror( errno ));
          }
	  else
	  {
              rc = read(fd, &s, sizeof( lwpstatus_t ) );
              if ( rc < sizeof( lwpstatus_t ) )
              {
	            P "ERROR: Failed to read LWP status info for lwpid(%d)!!!\n", lwpid );
              }
	      else
	      {
		P "LWP ID: %d\n", lwpid );

		pos = printLWPstatus( buf, pos, &s );

		P "\n\n------------------------------------------------------------" );
		P "------------------------------------------------------------\n\n");
	      }
	      close( fd );
	  }


	  if ( pos > (MAX_LWP_INFO - 5000) )
	  {
		P "\n\nToo many threads for text buffer!!!! Increase MAX_LWP_INFO\n" );
		break;
	  }
	 }

	}

	if ( dirp ) closedir( dirp );

	pos = strlen( buf );

	sprintf( dialogTitle, "Light Weight Process Status Details for pid(%d)", pid );
	do_detailPopup( w, dialogTitle, 25, 120, False, buf );
}


#define MAX_DETAIL_INFO 20000


void
do_Info( w, pid, call_data )
Widget w;
int pid;
void *call_data;
{
	char 		path[MAX_PATH];
        psinfo_t 	s;
	int 		i, pos, rc, fd;
	char 		buf[MAX_DETAIL_INFO];
	char 		dialogTitle[128];


	sprintf( path, "%s/%d/psinfo", PROCESS_INFO_DIRECTORY, pid );

	pos = 0;

        fd = open( path, O_RDONLY );
        if ( fd == -1 )
        {
	    P "ERROR: Can't open process info file:%s!!!\n\n%s\n", 
					path, strerror( errno ));
        }
	else
	{
            rc = read(fd, &s, sizeof( psinfo_t ) );
            if ( rc < sizeof( psinfo_t ) )
            {
	        P "ERROR: Failed to read process info structure!!!\n" );
            }
	    else
	    {
		P "For details on fields see man proc(4) and files:\n\n");
		P "\t/usr/include/sys/procfs.h\n" );
		P "\n" );

		P "Flags:\t\t 0x%lX\n", s.pr_flag );
		P "Nlwp:\t\t %d\n", s.pr_nlwp );

		P "UID:\t\t %d\n", s.pr_uid );
		P "GID:\t\t %d\n", s.pr_gid );
		P "PID:\t\t %d\n", s.pr_pid );
		P "PPID:\t\t %d \t\t- Parent PID\n", s.pr_ppid );
		P "PGRP:\t\t %d \t\t- PID of Process Group Leader\n", s.pr_pgid );
		P "SID:\t\t %d \t\t- PID of Session Leader\n", s.pr_pgid );

		P "Addr:\t\t 0x%8.8lX (%lu)\n", s.pr_addr, s.pr_addr );
		P "size:\t\t %d bytes\n", s.pr_size );
		P "rssize:\t\t %d bytes\n", s.pr_rssize );

		P "start:\t\t %ld.%ld\n", s.pr_start.tv_sec, s.pr_start.tv_nsec );
		P "time:\t\t %ld.%ld\n", s.pr_time.tv_sec, s.pr_time.tv_nsec );

		P "ttydev:\t\t 0x%X\n", s.pr_ttydev );

		P "fname:\t\t %s\n", s.pr_fname );
		P "psargs:\t\t %s\n", s.pr_psargs );

		P "\nRepresentative LWP\n\n" );

		pos = printLWPinfo( buf, pos, &s.pr_lwp );
	    }
	}


	pos = strlen( buf );

	sprintf( dialogTitle, "Details for pid(%d)", pid );
	do_detailPopup( w, dialogTitle, 39, 80, False, buf );
}



int
printLWPinfo( buf, pos, s )
char *buf;
int pos;
lwpsinfo_t *s;
{
	int i;

	P "Flags:\t\t 0x%lX\n", s->pr_flag );
	P "lwpid:\t\t %d\n", s->pr_lwpid );
	P "addr:\t\t 0x%8.8lX\n", s->pr_addr );
	P "wchan:\t\t 0x%8.8lX\n", s->pr_wchan );
	P "stype:\t\t 0x%x\n", (int ) s->pr_stype );
	P "state:\t\t %d\n", (int) s->pr_state );
	if ( s->pr_sname != '\0' ) P "sname:\t\t '%c'\n", s->pr_sname );
	P "nice:\t\t %d\n", (int) s->pr_nice );
	P "pri:\t\t %d\n", s->pr_pri );
	P "time:\t\t %lu.%9.9lu sec\n", s->pr_time.tv_sec, s->pr_time.tv_nsec );
	P "class:\t\t %s\n", s->pr_clname );
	P "name:\t\t %s\n", s->pr_name );
	P "OnProcessor:\t %d\n", s->pr_onpro );
	P "BoundTo:\t %d\n", s->pr_bindpro );
	P "ExBound:\t %d\n", s->pr_exbindpro );

	return pos;
}

Widget
do_detailPopup( w, title, rows, cols, wrap, text )
Widget w;
char *title;
int rows, cols;
Boolean wrap;
char *text;
{
	int             n;
	XmString	title_str, exit_str, message_str, infoStr;
	Widget 		textw, textSW, dw;
        Arg             wargs[16];

        title_str   = XmStringCreate( title, XmSTRING_DEFAULT_CHARSET );
        exit_str    = XmStringCreate("Done", XmSTRING_DEFAULT_CHARSET );
        message_str = XmStringCreate( title, XmSTRING_DEFAULT_CHARSET );

        n = 0;
        XtSetArg( wargs[n], XmNdialogTitle,   title_str ); n++;
        XtSetArg( wargs[n], XmNokLabelString, exit_str ); n++;
        XtSetArg( wargs[n], XmNmessageString, message_str ); n++;
        XtSetArg( wargs[n], XmNmessageAlignment,  XmALIGNMENT_CENTER ); n++;
        XtSetArg( wargs[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON ); n++;
#ifdef LESSTIF
        XtSetArg( wargs[n], XmNsymbolPixmap, XmUNSPECIFIED_PIXMAP ); n++;
#else
        XtSetArg( wargs[n], XmNsymbolPixmap, NULL ); n++;
#endif
        dw = XmCreateInformationDialog(w, title, wargs, n);
        if ( dw == NULL )
        {
            DEBUG0(1, "do_detailPopup: Failed to create\n");
            return;
        }

        XtUnmanageChild( XmMessageBoxGetChild( dw, XmDIALOG_HELP_BUTTON ));
        XtUnmanageChild( XmMessageBoxGetChild( dw, XmDIALOG_CANCEL_BUTTON));

        n = 0;
        XtSetArg( wargs[n], XmNdialogTitle,   title_str ); n++;
        XtSetArg( wargs[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
        XtSetArg( wargs[n], XmNcursorPositionVisible, False ); n++;
        XtSetArg( wargs[n], XmNeditable, False ); n++;
        XtSetArg( wargs[n], XmNcolumns, cols ); n++;
        XtSetArg( wargs[n], XmNrows, rows ); n++;
        XtSetArg( wargs[n], XmNwordWrap, wrap ); n++;
	textw = XmCreateScrolledText( dw, "detailsText", wargs, n );

        n = 0;
        XtSetArg( wargs[n], XmNvalue, text ); n++;
        XtSetValues( textw, wargs, n );

        XtManageChild( textw );

        XtManageChild( dw );

	return textw;
}


nullToNewline( len, buf )
int len;
char *buf;
{
	int i;

	if ( buf == NULL )
		return;

	for ( i = 0; i < len ; i++ )
	{
		if ( buf[i] == NULL_CHAR )
			buf[i] = '\n';
	}

	buf[i] = NULL_CHAR;
}



