/* File: 	config.h
 *
 * Description: This file contains #defines that are the most likely to
 *		be changed.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1995, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	4/14/95	Created
 * 		George MacDonald	10/27/98 Moved to platform dir
 *
 */

#ifndef CONFIGH
#define CONFIGH

#include "localized.h"          /* Local definitions, locations, ...*/
#include "security.h"           /* Include default security model */


/*
 * Here we coerce the systems process info structure into a type which is
 * used throughout the program. The reason for this is that the structure
 * prpsinfo_t was changed to psinfo_t when support for Multi-processors 
 * and LWP's was added. Many of the fields remained the same, so to 
 * minimise the number of typedef's throughout the code I decided to use
 * this technique. This should all be changed to become a more modular
 * data gathering/display package in future releases.
 *
 */

#include <sys/procfs.h>

#ifdef SVR4_MP
	typedef psinfo_t 	  sysProcInfo;
#else
	typedef prpsinfo_t        sysProcInfo;
#endif

/* Some macros to hide process info structure differences */

/* First the multi-threaded multi-processor version of SVR4 */

#ifdef SVR4_MP

#define PROCESS_SNAME( pp )  			( pp->pr_lwp.pr_sname )
#define PROCESS_NICE( pp )  			( pp->pr_lwp.pr_nice )
#define PROCESS_FLAG( pp )  			( pp->pr_flag )
#define PROCESS_USER_ID( pp )  			( pp->pr_uid )
#define PROCESS_GROUP_ID( pp ) 			( pp->pr_gid )
#define PROCESS_ID( pp ) 			( pp->pr_pid )
#define PROCESS_PARENT_ID( pp )  		( pp->pr_ppid )
#if defined(UW7)
#define PROCESS_GROUP_LEADER(pp) 		( pp->pr_pgid )
#else
#define PROCESS_GROUP_LEADER(pp) 		( pp->pr_pgrp )
#endif
#define PROCESS_SESSION_ID( pp )  		( pp->pr_sid )
#define PROCESS_ADDRESS( pp )  			( pp->pr_addr )
#define PROCESS_SIZE( pp ) 			( pp->pr_size )
#define PROCESS_RESIDENT_SET_SIZE( pp ) 	( pp->pr_rssize )
#define PROCESS_WCHAN( pp )  			( pp->pr_lwp.pr_wchan )
#define PROCESS_START_TIME( pp ) 		( pp->pr_start )
#define PROCESS_CPU_TIME( pp ) 			( pp->pr_time )
#define PROCESS_PRIORITY( pp )  		( pp->pr_lwp.pr_pri )
#define PROCESS_OLD_PRIORITY( pp )  		( 0 )
#define PROCESS_CPU( pp )  			( 0 )
#define PROCESS_CPU( pp )  			( 0 )
#define PROCESS_NUM_LWP( pp )  			( pp->pr_nlwp )
#define PROCESS_ON_PROCESSOR( pp )		( pp->pr_lwp.pr_onpro )
#define PROCESS_CONTROL_TTY( pp )  		( pp->pr_ttydev )
#define PROCESS_CLASS_NAME( pp )  		( pp->pr_lwp.pr_clname )
#define PROCESS_CMD_NAME( pp )  		( pp->pr_fname )
#define PROCESS_CMD_ARGS( pp ) 			( pp->pr_psargs )

#define PROCESS_EFFECTIVE_USER_ID( pli_ptr )  	( pli_ptr->euid )
#define PROCESS_EFFECTIVE_GROUP_ID( pli_ptr ) 	( pli_ptr->egid )

#else   /* Vanilla V.4 */

#define PROCESS_SNAME( pp )                     ( pp->pr_sname )
#define PROCESS_NICE( pp )                      ( pp->pr_nice )
#define PROCESS_FLAG( pp )                      ( pp->pr_flag )
#define PROCESS_USER_ID( pp )                   ( pp->pr_uid )
#define PROCESS_GROUP_ID( pp )                  ( pp->pr_gid )
#define PROCESS_ID( pp )                        ( pp->pr_pid )
#define PROCESS_PARENT_ID( pp )                 ( pp->pr_ppid )
#define PROCESS_GROUP_LEADER(pp)                ( pp->pr_pgrp )
#define PROCESS_SESSION_ID( pp )                ( pp->pr_sid )
#define PROCESS_ADDRESS( pp )                   ( pp->pr_addr )
#define PROCESS_SIZE( pp )                      ( pp->pr_size )
#define PROCESS_RESIDENT_SET_SIZE( pp )         ( pp->pr_rssize )
#define PROCESS_WCHAN( pp )                     ( pp->pr_wchan )
#define PROCESS_START_TIME( pp )                ( pp->pr_start )
#define PROCESS_CPU_TIME( pp )                  ( pp->pr_time )
#define PROCESS_PRIORITY( pp )                  ( pp->pr_pri )
#define PROCESS_OLD_PRIORITY( pp )              ( pp->pr_oldpri )
#define PROCESS_CPU( pp )                       ( pp->pr_cpu )
#define PROCESS_CONTROL_TTY( pp )               ( pp->pr_ttydev )
#define PROCESS_CLASS_NAME( pp )                ( pp->pr_clname )
#define PROCESS_CMD_NAME( pp )                  ( pp->pr_fname )
#define PROCESS_CMD_ARGS( pp )                  ( pp->pr_psargs )

#define PROCESS_EFFECTIVE_USER_ID( pli_ptr )    ( pli_ptr->euid )
#define PROCESS_EFFECTIVE_GROUP_ID( pli_ptr )   ( pli_ptr->egid )

#endif


#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif

#ifndef NULL_STR
#define NULL_STR	((char *) NULL)
#endif

#ifndef EMPTY_STR
#define EMPTY_STR	("")
#endif


#endif CONFIGH
