/* File: 	usr_group_mb.c
 *
 * Description: Routines to create and process user_group menu's.
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1993, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	2/10/95	Created
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/SeparatoG.h>
#include <Xm/RowColumn.h>

#include <Xpsi/Tree.h>  /* our own custom Tree widget              */


#include "libXs.h"
#include "config.h"
#include "tree.h"
#include "user_group.h"
#include "debug.h"

Widget setup_user_group_menu();

void 		do_ug_group();
void 		do_ug_user();
void 		do_ug_help();

xs_menu_struct UGGroupMenuData[]={
	{"Radio",             "1", NULL_STR, NULL, NULL_STR, NULL, 
							0, NULL_STR},
	{"All Group Id's",        "A", NULL_STR, do_ug_group, "all", NULL, 
							0, NULL_STR},
	{"Only if Child Visible", "C", NULL_STR, do_ug_group, "none", NULL, 
							0, NULL_STR},
	{"Login Group",       "L", NULL_STR, do_ug_group, "in", NULL, 
							0, NULL_STR},
	{"Logged In Groups",  "G", NULL_STR, do_ug_group, "ins", NULL, 
							0, NULL_STR},
	{"Background Group Id's", "B", NULL_STR, do_ug_group, "back", NULL, 
							0, NULL_STR},
	{"Active Group Id's","t", NULL_STR, do_ug_group, "act", NULL, 
							0, NULL_STR},
};

xs_menu_struct UGUserMenuData[]={
	{"Radio",            "5", NULL_STR, NULL, NULL_STR, NULL, 
							0, NULL_STR},
	{"All User Id's",        "A", NULL_STR, do_ug_user, "all", NULL, 
							0, NULL_STR},
	{"No Users",         "N", NULL_STR, do_ug_user, "none", NULL, 
							0, NULL_STR},
	{"Login User",       "L", NULL_STR, do_ug_user, "in", NULL, 
							0, NULL_STR},
	{"Logged In Users",  "U", NULL_STR, do_ug_user, "ins", NULL, 
							0, NULL_STR},
	{"Background User Id's", "B", NULL_STR, do_ug_user, "back", NULL, 
							0, NULL_STR},
	{"Active User Id's","t", NULL_STR, do_ug_user, "act", NULL, 
							0, NULL_STR},
};

xs_menu_struct UGHelpMenuData[]={
	{"About",  "A", NULL_STR,   do_ug_help, "about", NULL, 
							0, NULL_STR},
};

xs_menu_struct UGPulldownData[]={
	{"Groups", "G",NULL_STR, NULL, 
			NULL_STR, (struct _menu_struct *)UGGroupMenuData,
			XtNumber(UGGroupMenuData), "View"},
	{"Users",  "U", NULL_STR, NULL, 
			NULL_STR, (struct _menu_struct *)UGUserMenuData,
			XtNumber(UGUserMenuData), "View"},
	{"Help", "H", NULL_STR, NULL, 
			NULL_STR, (struct _menu_struct *)UGHelpMenuData, 
			XtNumber(UGHelpMenuData), "Help"},
};

extern Debug;

static User_group_info *UG;

Widget
setup_user_group_menu( users )
User_group_info  *users;
{
	Widget 	menuMW;
	Widget 	sep;
	Arg 	wargs[10];
	int 	n;

	DEBUG0(1, "setup_user_group_menu\n" );

	n = 0;
	XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	menuMW = XmCreateMenuBar( users->form_w, "menubar", wargs, n );
	XtManageChild( menuMW );

	xs_create_menu_buttons( NULL, menuMW, UGPulldownData,
					XtNumber(UGPulldownData));
	n = 0;
	XtSetArg( wargs[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg( wargs[n], XmNtopWidget, menuMW); n++;
	XtSetArg( wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg( wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	sep = XtCreateManagedWidget( "ugseparator1", xmSeparatorGadgetClass, 
						users->form_w, wargs, n );

	UG = users;
	return( sep );
}

void 
do_ug_group( w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	int new_value=0;

	DEBUG1( 1, "do_ug_group client data(%s)\n", client_data);

	if ( strcmp(client_data, "all") == 0 )
	{
		new_value = VIEW_ALL_GROUPS;
	}
	else if ( strcmp(client_data, "none") == 0 )
	{
		new_value = VIEW_IGNORE_GROUPS;
	}
	else if ( strcmp(client_data, "in") == 0 )
	{
		new_value = VIEW_LOGGED_IN_GROUP;
	}
	else if ( strcmp(client_data, "ins") == 0 )
	{
		new_value = VIEW_LOGGED_IN_GROUPS;
	}
	else if ( strcmp(client_data, "back") == 0 )
	{
		new_value = VIEW_BACKGROUND_GROUPS;
	}
	else if ( strcmp(client_data, "act") == 0 )
	{
		new_value = VIEW_ACTIVE_GROUPS;
	}

	if ( new_value != UG->group_view )
	{
		UG->group_view = new_value;
		display_user_group( UG );
	}
}

void 
do_ug_user( w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	int new_value=0;

	DEBUG1( 1, "do_ug_user client data(%s)\n", client_data);

	if ( strcmp(client_data, "all") == 0 )
	{
		new_value = VIEW_ALL_USERS;
	}
	else if ( strcmp(client_data, "none") == 0 )
	{
		new_value = VIEW_NO_USERS;
	}
	else if ( strcmp(client_data, "in") == 0 )
	{
		new_value = VIEW_LOGGED_IN_USER;
	}
	else if ( strcmp(client_data, "ins") == 0 )
	{
		new_value = VIEW_LOGGED_IN_USERS;
	}
	else if ( strcmp(client_data, "back") == 0 )
	{
		new_value = VIEW_BACKGROUND_USERS;
	}
	else if ( strcmp(client_data, "act") == 0 )
	{
		new_value = VIEW_ACTIVE_USERS;
	}

	if ( new_value != UG->user_view )
	{
		UG->user_view = new_value;
		display_user_group( UG );
	}
}

void 
do_ug_help( w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	DEBUG1( 1, "do_ug_help client data(%s)\n", client_data);

	show_help( w, "user_group" );
}

