/* button_bar.h:  Include file for button bar structures
 *
 */

#ifndef BBARH
#define BBARH


#define LABEL_TYPE	1	/* If button in button bar is to be a label */
#define PIXMAP_TYPE	2	/* If it's a pixmap graphic		    */


/* The following is the structure to hold each buttons information */

typedef struct button_rec {
	int		 type;		/* LABEL_TYPE or PIXMAP_TYPE    */
	char		*unarm_fname;   /* Filename of unpressed icon   */
	char		*arm_fname;     /* NULL implies same image as unarm */
	char		*unarm_label;   /* Displayable Button Label	*/
	char		*arm_label;
	int		 armed;	        /* If true button is armed      */
	int		 toggle_number; /* 0 single, 1 starts new radio */
	unsigned char 	*unarm_bits;	/* raw bits                     */
	unsigned char 	*arm_bits;
	int		 width;		/* icon width		        */
	int		 height;
	int		 left_offset;   /* Distance from left widget    */
	void 		 (*cb_func)();  /* callback function		*/
	char  		*cb_data;	/* data passed in callback	*/

	Pixmap		 default_unarm_pixmap;	/* Used to cache mono/16 */
	Pixmap		 default_arm_pixmap;

	Pixmap		 unarm_pixmap;	
	Pixmap		 arm_pixmap;
	XmString	 unarm_label_str; /* calculated from label      */
	XmString	 arm_label_str;
	Widget		 w;		/* Filled in after created       */

	int		active;   /* If true button is displayed   */
	char		*widgetTip; 
} Button_item;


extern Button_item  *Buttons;
extern int	     Button_cnt;

#define NULL_BUTTONS ((Button_item *) 0)

extern int setButtonParameters();


#endif /* BBARH */
