/* 
 * loadValues.h -  load linux process values include file
 *
 * Loads linux process values from 
 *
 * 	/proc/<pid>/*
 */

#ifndef LOAD_LINUX_VALUES
#define LOAD_LINUX_VALUES

#include <sys/param.h>

struct linuxProcessStat {
	char		*cmdLine;	/* From cat /proc/<pid>/cmdline */

	int		uid;	/* Get from /proc/<pid>/status */
	int		euid;
	int		gid;
	int		egid;

	int		pid;		/* From /proc/<pid>/stat    */
	char 		fname[40];
	char		state;
	int		ppid;
	int		pgrp;
	int		sid;
	int		tty;
	int		tpgid;
	unsigned int	flags;
	unsigned int    minflt;
	unsigned int    cminflt;  /* process + children */
	unsigned int    majflt;
	unsigned int    cmajflt;  /* process + children */
	int		utime;
	int		stime;
	int		cutime;
	int		cstime;
	int		priority;
	int		nice;
	unsigned int    timeout; 
	unsigned int    itrealvalue; 
	int    		starttime; 
	unsigned int    vsize; 
	unsigned int    rss; 
	unsigned int    rlim; 
	unsigned int    startcode; 
	unsigned int    endcode; 
	unsigned long   startstack; 
	unsigned long   kstkesp; 
	unsigned int    kstkeip; 
	int    		signal; 
	int    		blocked; 
	int    		sigIgnore; 
	int    		sigCatch; 
	unsigned int    wchan; 
	unsigned int    nswap; 
	unsigned int    cnswap; 
	unsigned int    exitcode; 
};


char * startTimeStr( unsigned long start_time );


#endif
