/* File: 	linuxPsInfo.h
 *
 * Description: Private Linux'ized version of psinfo structure
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1998, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	10/16/98	Created
 *
 */

#ifndef LINUX_PSINFO
#define LINUX_PSINFO

#define LINUX_PROCESS_ARG_SIZE  1024
#define LINUX_CLASS_NAME_SIZE    8
#define LINUX_FILE_NAME_SIZE    16

typedef struct linux_psinfo {
       char    		pr_sname; 
       char    		pr_nice;
       u_long  		pr_flag;
       uid_t   		pr_uid;
       gid_t   		pr_gid;
       pid_t   		pr_pid;
       pid_t   		pr_ppid;
       pid_t   		pr_pgrp;
       pid_t   		pr_sid;
       caddr_t 		pr_addr;
       long    		pr_size;
       long    		pr_rssize;
       caddr_t 		pr_wchan;
       timestruc_t 	pr_start;
       timestruc_t 	pr_time;
       long    		pr_pri;    
       dev_t   		pr_ttydev; 
       char    		pr_clname[LINUX_CLASS_NAME_SIZE]; 
       char    		pr_fname[LINUX_FILE_NAME_SIZE]; 
       char    		*pr_psargs;
       timestruc_t 	last_time;

} linux_psinfo_t;


#endif 
