/* File: 	config.h
 *
 * Description: This file contains platform #defines for linux
 *
 * Author:	George MacDonald
 *
 * Copyright:	Copyright (c) 1998, Pulsar Software Inc.
 *		All Rights Reserved, Unpublished rights reserved.
 *
 * History:	George MacDonald	10/20/98	Created
 *
 */

#ifndef CONFIGH
#define CONFIGH


#ifdef __linux__
#define LINUX
#endif

#include "localized.h"  	/* Local definitions, locations, ...*/
#include "security.h"		/* Include default security model */



/* Linux is quite a bit different than other systems with the /proc
 * structure. On linux the process info is not accessed by reading
 * a binary structure from a file, nor is it available via an ioctl 
 * call. Instead the values can be retrieved by reading and parsing files in
 *
 *	/proc/<PID>/*
 *
 * On linux a psinfo structure exists, but as of yet it does not
 * have all the values we want and there is also no convenient way
 * to load the structure(at least I couldn't find one). Anyhow we
 * create our own structure on linux ( see linux_psinfo.h )
 * which serves the same function as prpsinfo structure. This is 
 * populated by reading the files in the  /proc/pid directory and 
 * accessed via the macros defined below.
 */

#include <sys/procfs.h>

typedef struct timespec timestruc_t; 

#include "linuxPsInfo.h"
#include "loadValues.h"

typedef linux_psinfo_t        sysProcInfo; 

#include <sys/sysmacros.h>    /* for major and minor macros */


/* Some macros to hide process info structure differences */


#define PROCESS_SNAME( pp )  			( pp->pr_sname )
#define PROCESS_NICE( pp )  			( pp->pr_nice )
#define PROCESS_FLAG( pp )  			( pp->pr_flag )
#define PROCESS_USER_ID( pp )  			( pp->pr_uid )
#define PROCESS_GROUP_ID( pp ) 			( pp->pr_gid )
#define PROCESS_ID( pp ) 			( pp->pr_pid )
#define PROCESS_PARENT_ID( pp )  		( pp->pr_ppid )
#define PROCESS_GROUP_LEADER(pp) 		( pp->pr_pgrp )
#define PROCESS_SESSION_ID( pp )  		( pp->pr_sid )

#define PROCESS_ADDRESS( pp )  			( pp->pr_addr )
#define PROCESS_SIZE( pp ) 			( pp->pr_size )
#define PROCESS_RESIDENT_SET_SIZE( pp ) 	( pp->pr_rssize )
#define PROCESS_WCHAN( pp )  			( pp->pr_wchan )
#define PROCESS_START_TIME( pp ) 		( pp->pr_start )
#define PROCESS_CPU_TIME( pp ) 			( pp->pr_time )
#define PROCESS_PRIORITY( pp )  		( pp->pr_pri )
#define PROCESS_OLD_PRIORITY( pp )  		( 0 )
#define PROCESS_CPU( pp )  			( 0 )
#define PROCESS_CONTROL_TTY( pp )  		( pp->pr_ttydev )
#define PROCESS_CLASS_NAME( pp ) 		( pp->pr_clname )

#define PROCESS_CMD_NAME( pp )  		( pp->pr_fname )
#define PROCESS_CMD_ARGS( pp ) 			( pp->pr_psargs )

#define PROCESS_EFFECTIVE_USER_ID( pli_ptr )  	( pli_ptr->euid )
#define PROCESS_EFFECTIVE_GROUP_ID( pli_ptr ) 	( pli_ptr->egid )


#ifndef NULL_CHAR
#define NULL_CHAR	'\0'
#endif

#ifndef NULL_STR
#define NULL_STR	((char *) NULL)
#endif

#ifndef EMPTY_STR
#define EMPTY_STR	("")
#endif

/* On linux the following appear to be missing */

typedef short major_t;
typedef short minor_t;


#endif /* CONFIGH */
