/* the format for the string created by this procedure is:
   hostname
   domainname (its usually "(none)" for some reason
   arch type
   OS type
   os version
   os release
   # of users
   uptime in seconds
   load average (1 min)
   load average (5 min)
   load average (15 min)
   total ram (bytes)
   free ram
   total swap
   free swap
   # of procs
   total blocks on /
   blocks free on /
   total inodes on /
   free inodes on /

   all fields are delimited with a single pipe "|"
   */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/utsname.h>
#include <sys/sysinfo.h>
#include <sys/vfs.h>
#include <utmp.h>
#include <string.h>
#include <errno.h>

#include <sys/systm.h>
#include <sys/varargs.h>
#include <kvm.h>
#include <kstat.h>

#include "../getstatus.h"




void getstatus(char *stats) {
  struct utsname *unameinfo;
  struct statvfs *fsinfo;
  struct utmp *ut;
  char temp[4096], buf[128], *crud[6];
  int users=0, fds[2], j, i /* ,  hours, minutes */;
  FILE *forfds;
  long long                   TotalRam, FreeRam;
  long                        PageSize;
  long                        NumPages, FreePages;
  pid_t pid;
  

  unameinfo=malloc(sizeof(struct utsname));
  if(uname(unameinfo) < 0) {
    fputs("uname failed.\n",stderr);
    exit(127);
  }
  setutent();
  while((ut=getutent())!=NULL)
    if(ut->ut_type == USER_PROCESS)
      users++;
  endutent();
  fsinfo=malloc(sizeof(struct statvfs));
  if(statvfs("/",fsinfo) < 0) {
    fputs("fsinfo failed.\n", stderr);
    exit(127);
  }

  PageSize = sysconf(_SC_PAGESIZE);
  NumPages = sysconf(_SC_PHYS_PAGES);
  FreePages = sysconf(_SC_AVPHYS_PAGES);
  if (PageSize < 0 || NumPages < 0) {
    perror("sysconf");
    exit(127);
  }
  TotalRam = (long long) PageSize * NumPages;
  FreeRam  = (long long) PageSize * FreePages;


  if (pipe(fds) < 0)
    perror("pipe");
  
  if ( (pid = fork()) < 0) { /* fork to run /usr/bin/uptime */
    perror("fork");
    exit(127);
  }
  else if (pid == 0) { /* Child */
    close(fds[0]);
    dup2(fds[1],STDOUT_FILENO);
    execlp("/usr/bin/uptime","uptime",(char *) 0);
    perror("exec");
    exit(127);
  }

  /* Parent */
  close(fds[1]);


  forfds = fdopen(fds[0],"r");

  if (fgets(buf, 128, forfds) == NULL)
    exit(127);



  for (i=strlen(buf), j = 0; j < 3; i--) {

    if (buf[i] == ',' || buf[i] == ':') {
      buf[i] = 0;
      crud[j++] = &buf[i+1];
		    
    }
  }

  sprintf(temp, "%s|",unameinfo->nodename);
  strcpy(stats, temp);
  sprintf(temp, "DomainShouldGoHere|"); /* Couldn't Gather the Domain Name */
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->machine);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->sysname);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->version);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->release);
  strcat(stats, temp);
  sprintf(temp, "%i|", users);
  strcat(stats, temp);


  sprintf(temp,"0|");
  strcat(stats, temp);

  sprintf(temp, "%.2f|%.2f|%.2f|", atof(crud[0]), atof(crud[1]), atof(crud[2])); 
  strcat(stats, temp);


  sprintf(temp, "%lli|%lli|",TotalRam,FreeRam);
  strcat(stats,temp);


  sprintf(temp, "0|0|0|"); /* We don't know how to gather this info */

  strcat(stats, temp);

  sprintf(temp, "%li|%li|%li|%li|",
	  fsinfo->f_blocks,
	  fsinfo->f_bfree,
	  fsinfo->f_files,
	  fsinfo->f_ffree);
  strcat(stats, temp);



  free(fsinfo);
  free(unameinfo);


}








