/*
 * Signal handling help functions.
 * Eric Jeschke  4/20/1997
 */
#ifndef _SIG_h
#define _SIG_h

typedef void   Sigfunc (int); 

/*
 * Reimplementation of signal() to abstract across Unixes.
 * It does NOT reset signal handler after each signal and
 * it reliably restarts interrupted system calls.
 */
Sigfunc * signal (int signo, Sigfunc *func);

/*
 * If a process isn't interested in the exit status of its
 * children, and doesn't want to have them become zombies and
 * clog up the system, it can call this function before creating
 * any children.
 */
void  no_zombies (void);

#endif /*_SIG_h*/
