/*
 * Signal handling help functions.
 * Developed by Eric Jeschke  4/20/1997
 *
 * Some of this code is adapted from "Advanced Programming in
 * the Unix Environment" by W. Richard Stevens, ISBN 0-201-56317-7
 */

#include	<unistd.h>
#include	<errno.h>
#include	<signal.h>
#include	<sys/wait.h>
#include        <sys/types.h>

#include	"sig.h"

/*
 * Reimplementation of a reliable signal() function.
 */
Sigfunc *
signal (int signo, Sigfunc *func)
{
    struct sigaction   act, oact;

    act.sa_handler = func;
    sigemptyset (&act.sa_mask); 
    act.sa_flags = SA_RESTART;

    if (sigaction (signo, &act, &oact) < 0)
        return SIG_ERR;
    return oact.sa_handler;
}

/*
 * Generic signal handler for SIGCHLD.
 */
static void
sig_child (int signo)
{
        pid_t      pid;
        int        status, save_errno;

	save_errno = errno;

        /* Collect zombies with waitpid: */
        while ( (pid = waitpid(-1, &status, WNOHANG)) > 0) ;

	errno = save_errno;
}

/*
 * Prevent creation of zombie processes under Unix.
 */
void
no_zombies (void)
{
	void	sig_child(int signo);

	signal (SIGCHLD, sig_child);
}
