/* server.h

   This is the header file for the main program which resides in server.c.
*/



/* 
   Define the message structure that is used to communicate between
   forked child and parent. mtype specifies the message type while
   poll_time sets the appropriate poll_time and registered is needed
   for the NUKE! command.
   */
struct mymsg {
  long mtype;
  int  poll_time;
  int  registered;
};


/* The default port for clientd and serverd: */
#define SERVERD_PORT	5055
#define CLIENTD_PORT    5005

/* The default file to which the server logs errors: */
#define SERVER_LOG	"/tmp/clientd.log"
#define DEFAULT_WAIT 4   /* poll_time on initial startup */
#define WAIT_MULT 4      /* Multiple times poll_time to wait to re-register */
#define TRUE 1           /* Always handy TRUE and FALSE Definitions. */
#define FALSE 0

/* Define the printlog function so handlers.c can use it */
void printlog(char *, ...); 

/* Global vars. */
FILE	*log;			/* Daemon log file. */
char    *pname;			/* Server program name. */
int      poll_time;             /* Time interval to poll (sec) */
char    *register_to;           /* Machine to register to */
int      msqid;                 /* Message queue ID */


