/* the format for the string created by this procedure is:
   hostname
   domainname (its usually "(none)" for some reason
   arch type
   OS type
   os version
   os release
   # of users
   uptime in seconds
   load average (1 min)
   load average (5 min)
   load average (15 min)
   total ram (bytes)
   free ram
   total swap
   free swap
   # of procs
   total blocks on /
   blocks free on /
   total inodes on /
   free inodes on /

   all fields are delimited with a single pipe "|"
   */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/utsname.h>
#include <linux/kernel.h>
#include <linux/sys.h>
#include <sys/vfs.h>
#include <utmp.h>
#include <string.h>

#include "../getstatus.h"

extern int sysinfo(struct sysinfo *);

/* Gather System information and place it in stats */
void getstatus(char *stats) {
  struct utsname *unameinfo;
  struct sysinfo *info;
  struct statfs *fsinfo;
  struct utmp *ut;
  char temp[4096];
  int users=0;
  FILE *fd;
  float load1, load5, load15;
  
  unameinfo=malloc(sizeof(struct utsname));
  if(uname(unameinfo) < 0) {
    fputs("uname failed.\n",stderr);
    exit(127);
  }
  info=malloc(sizeof(struct sysinfo));
  if(sysinfo(info) < 0) {
    fputs("sysinfo failed.\n",stderr);
    exit(127);
  }
  fsinfo=malloc(sizeof(struct statfs));
  if(statfs("/",fsinfo) < 0) {
    fputs("fsinfo failed.\n", stderr);
    exit(127);
  }
  setutent();
  while((ut=getutent())!=NULL)
    if(ut->ut_type == USER_PROCESS)
      users++;
  endutent();
  sprintf(temp, "%s|",unameinfo->nodename);
  strcpy(stats, temp);
  sprintf(temp, "%s|",unameinfo->domainname);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->machine);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->sysname);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->version);
  strcat(stats, temp);
  sprintf(temp, "%s|",unameinfo->release);
  strcat(stats, temp);
  sprintf(temp, "%i|", users);
  strcat(stats, temp);
  sprintf(temp, "%li|",info->uptime);
  strcat(stats, temp);
  fd=fopen("/proc/loadavg", "r");
  fscanf(fd, "%f %f %f", &load1, &load5, &load15);
  fclose(fd);
  sprintf(temp, "%.2f|%.2f|%.2f|", load1, load5, load15);
  strcat(stats, temp);
  sprintf(temp, "%li|%li|%li|%li|%hi|",
	  info->totalram,
	  info->freeram,
	  info->totalswap,
	  info->freeswap,
	  info->procs);
  strcat(stats, temp);
  sprintf(temp, "%li|%li|%li|%li|",
	  fsinfo->f_blocks,
	  fsinfo->f_bfree,
	  fsinfo->f_files,
	  fsinfo->f_ffree);
  strcat(stats, temp);
  free(fsinfo);
  free(unameinfo);
  free(info);
}


