set host localhost
set port 5055
set poll 5
set setpoll 5
set labelfont "-adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*"
set labelsmall "-adobe-helvetica-*-r-*-*-10-*-*-*-*-*-*-*"
set iconfont "-adobe-helvetica-*-*-*-*-24-*-*-*-*-*-*-*"
set small "-adobe-helvetica-*-r-*-*-10-*-*-*-*-*-*-*"
set info "|"
set machlist {}
set machines(0) {}
set prevmachlist {}
set prevmachines(0) {}
set ostypes {Linux SunOS OpenVMS}
set curmachine 0
set servertalk 0
set cycling 1
set cycletime 3.0
set rdst 1
set rsst 1
set lat1 1.0
set lat2 2.0
set lds 10
set lss 10
set maxnumprocs 100

proc printmesg {color mesg} {
    .messages.out insert end "\n$mesg"
    .messages.out tag add $color "insert linestart" "insert lineend"
    .messages.out tag configure $color -foreground $color
    .messages.out see end
}

proc readinfo {} { # this procedure needs to read the info variable from the server
    global info
    global host
    global port
    global poll
    global servertalk

    if [catch {set sock [socket $host $port]}] {
	if {$servertalk == 1} {
	    printmesg "Red" "Unable to contact server at $host $port"
	    set servertalk 0
	}
    } else {
	if {$servertalk == 0} {
	    set servertalk 1
	    printmesg "green" "Established connection to server at $host $port"
	}
	fconfigure $sock -blocking false
	update
	puts $sock "SPEWFORTHALL\n"
	flush $sock
	gets $sock info
	while {[fblocked $sock]} {
	    gets $sock info
	    update
	}
	flush $sock
	update
	puts $sock "POLL $poll\n"
	flush $sock
	update
	puts $sock "QUIT\n"
	flush $sock
	close $sock
    }
}

proc getnewmachines {} {
    global info
    global newmachines
    global newmachlist

#    printmesg "Green" "Polling..."
    readinfo
    set left 0
    set j 0
    set newmachlist {}
    while {[string length $info] > 1} {
	set newmachines($j) {}
	for {set i 1} {$i < 22} {incr i 1} {
	    set right [string first "|" $info]
	    if {$i == 1} {
		set period [string first "." $info]
		if {$period > $right} {
		    set period $right
		}
		lappend newmachlist [string range $info $left [expr $period-1]]
	    }
	    lappend newmachines($j) [string range $info $left [expr $right-1]]
#	    printmesg "Purple" [lindex $newmachines($j) [expr $i-1]]
	    #	set left [expr $right+1]
	    set info [string range $info [expr $right+1] [expr [string length $info]-1]]
	}
	incr j 1
    }
}

proc makenewmachine {name type} {
    global iconfont
    global ostypes

# figure out where to put the icon
    set i 0
    set x1 0
    set y1 0
    set x2 70
    set y2 70
    set icons [.view.c find overlapping $x1 $y1 $x2 $y2]
#    printmesg "yellow" "icons is $icons"
    while {[llength $icons] > 0} {
	if {$i > 6} {
	    set i 0
	    set y1 [expr $y1+10]
	}
	    
	update
#	printmesg "white" "in while loop: $x1  $y1  $x2  $y2"
	set x1 [expr $i*70]
	set x2 [expr $x1+70]
	set y2 [expr $y1+60]
	set icons [.view.c find overlapping $x1 $y1 $x2 $y2]
#	printmesg "white" "icons is $icons"
#	printmesg "white" [llength $icons]
	incr i 1
    }

#    set [.view.c create text 3c 1c -text $name -font $iconfont]
    if {[lsearch $ostypes $type] == -1} {
	set type "unknown"
    }
    image create photo $name.photo -format gif -file "$type.gif"
    set x [expr $x1+70]
    set y [expr $y1+100]
    set x2 [expr $x1+70]
    set y2 [expr $y1+50]
    .view.c create text $x $y -text $name -font $iconfont -tags $name
    .view.c addtag colorable withtag $name
    .view.c create image $x2 $y2 -image $name.photo -tags $name
    .view.c addtag moveable withtag $name
#    .view.c addtag $name withtag nonmoveable
#    printmesg "White" "Added Icon '$name'"
}

proc destroymachine {name} {
    .view.c delete $name
#    printmesg "White" "Removed Icon '$name'"
}


proc updatemachines {} {
    global curmachine
    global machines
    global machlist
    global newmachines
    global newmachlist

    set i 0
#    printmesg "Yellow" "newmachlist is: $newmachlist"
#    printmesg "Yellow" "machlist is: $machlist"
    foreach mach $newmachlist {
	# see if each machine is part of the current list
	set index [lsearch $machlist $mach]
	if {$index == -1} { # machine doesnt exist yet
	    # determine the os type so we can choose an icon
	    set type [lindex $newmachines([lsearch $newmachlist $mach]) 3]
	    # make the new icon
	    printmesg "Green" "Found new machine:  $mach"
	    makenewmachine $mach $type
	}
	incr i 1
    }
    # check for machines that have disappeared
    foreach mach $machlist {
	set index [lsearch $newmachlist $mach]
	if {$index == -1} { # machine has disappeared
	    # destroy the machine
	    printmesg "Red" "Lost contact with machine:  $mach"
	    destroymachine $mach
	    # see if we are destroying the machine currently displayed
	    if {$mach == $curmachine} {
		set curmachine 0
		removestats       # clear the info display
	    }
	}
    }
    # copy newmachlist and newmachines to machlist and machines
    set size [array size newmachines]
    for {set i 0} {$i < $size} {incr i 1} {
	set machines($i) $newmachines($i)
    }
    set machlist $newmachlist
}

proc warnme {warn} {
    global machines
    global machlist
    global prevmachines
    global prevmachlist
    global host
    global port
    global servertalk
    global rdst
    global rsst
    global lat1
    global lat2
    global lds
    global lss
    global poll
    global maxnumprocs

#    printmesg "white" "prevmachlist is $prevmachlist"
#    printmesg "white" "machlist is $machlist"
    if {$warn == 1 && $servertalk == 0} {
	printmesg "red" "Unable to contact $host $port"
    }

    foreach mach $machlist {
	# see if this machine is in the prevmachlist
	set previndex [lsearch $prevmachlist $mach]
	if {$previndex != -1} { # machine is new, so dont do this
	    set index [lsearch $machlist $mach]
#	    printmesg "white" "machine is $mach"

	    # check for load average warnings

	    if {[lindex $machines($index) 8] >= $lat2 && ($warn == 1 || [lindex $prevmachines($previndex) 8] < $lat2)} {
		printmesg "red" "Load Average above $lat2 on $mach"
	    } elseif {[lindex $machines($index) 8] >= $lat1 && ($warn == 1 || [lindex $prevmachines($previndex) 8] < $lat1)} {
		printmesg "yellow" "Load Average above $lat1 on $mach"
	    }
	    
	    # check for swap space warnings

	    set prevmaxswap [lindex $prevmachines($previndex) 13]
	    set curmaxswap [lindex $machines($index) 13]
	    set prevfreeswap [lindex $prevmachines($previndex) 14]
	    set curfreeswap [lindex $machines($index) 14]
	    if {$prevmaxswap == 0 || $curmaxswap == 0} {
		set prevpercentfree 100
		set percentfree 100
	    } else {
		set prevpercentfree [expr 100*(double($prevfreeswap)/double($prevmaxswap))]
		set percentfree [expr 100*(double($curfreeswap)/double($curmaxswap))]
	    }
	    if {$percentfree <= $lss && ($warn == 1 || $prevpercentfree > $lss)} {
		printmesg "red" "Free Swap Space below $lss percent on $mach"
	    }
	    if {abs($prevpercentfree - $percentfree) >= $rsst} {
		set change [expr ($curfreeswap - $prevfreeswap) / 1024]
		printmesg "yellow" "Free Swap Space changing rapidly on $mach ($change k in $poll seconds)"
	    }
	    
	    #check for disk space warnings

	    set prevmaxblocks [lindex $prevmachines($previndex) 16]
	    set curmaxblocks [lindex $machines($index) 16]
	    set prevfreeblocks [lindex $prevmachines($previndex) 17]
	    set curfreeblocks [lindex $machines($index) 17]
	    if {$prevmaxblocks == 0 || $curmaxblocks == 0} {
		set prevpercentfree 100
		set percentfree 100
	    } else {
		set prevpercentfree [expr 100*double($prevfreeblocks) / double($prevmaxblocks)]
		set percentfree [expr 100*(double($curfreeblocks) / double($curmaxblocks))]
	    }
#	    printmesg "white" "$prevfreeblocks $prevmaxblocks $curfreeblocks $curmaxblocks $prevpercentfree $percentfree"
	    if {$percentfree <= $lds && ($warn == 1 || $prevpercentfree > $lds)} {
		printmesg "red" "Free Disk Space below $lds percent on $mach"
	    }
	    if {(abs($prevpercentfree - $percentfree) >= $rdst)} {
		set change [expr $curfreeblocks - $prevfreeblocks]
		printmesg "yellow" "Free Disk Space changing rapidly on $mach  ($change blocks in $poll seconds)"
	    }

	    # check for large numbers of processes

	    set processes [lindex $machines($index) 15]
	    set prevprocesses [lindex $prevmachines($previndex) 15]
	    if {$processes > $maxnumprocs && ($warn == 1 || $prevprocesses <= $maxnumprocs)} {
		printmesg "yellow" "High number of processes ($processes) on $mach"
	    }

	    update
	}
    }
    set prevmachlist $machlist
    set size [array size machines]
    for {set i 0} {$i < $size} {incr i 1} {
	set prevmachines($i) $machines($i)
    }    
}

proc removestats {} {
    .stats.static.host.hostname delete 1.0 1.end
    .stats.static.arch.archtype delete 1.0 1.end
    .stats.static.os.ostype delete 1.0 1.end
    .stats.dynamic.users.num delete 1.0 1.end
    .stats.dynamic.users.procs delete 1.0 1.end
    .stats.dynamic.up.uptime delete 1.0 1.end
    .stats.dynamic.loads.load1 delete 1.0 1.end
    .stats.dynamic.loads.load5 delete 1.0 1.end
    .stats.dynamic.loads.load15 delete 1.0 1.end
    .stats.mem.ram.c delete bar
    .stats.mem.swap.c delete bar
    .stats.disk.blocks.c delete bar
    .stats.disk.inodes.c delete bar
    .stats.mem.ram.max delete 1.0 1.end
    .stats.mem.ram.cur delete 1.0 1.end
    .stats.mem.swap.max delete 1.0 1.end
    .stats.mem.swap.cur delete 1.0 1.end
    .stats.disk.blocks.max delete 1.0 1.end
    .stats.disk.blocks.cur delete 1.0 1.end
    .stats.disk.inodes.max delete 1.0 1.end
    .stats.disk.inodes.cur delete 1.0 1.end
}

proc updatestats {mach} {
    global machines
    global machlist
    global curmachine

    if {$curmachine != 0} {
	removestats
    }
    foreach machine $machlist {
	.view.c itemconfigure colorable -fill black
    }
    .view.c itemconfigure [lindex [.view.c find withtag $mach] 0] -fill blue
    set curmachine $mach
#    printmesg "white" "mach is: $mach"
#    printmesg "white" "machlist is: $machlist"
#    printmesg "purple" "Updating machine '$mach'"
    set index [lsearch $machlist $mach]
    .stats.static.host.hostname insert end [lindex $machines($index) 0]
    .stats.static.arch.archtype insert end [lindex $machines($index) 2]
    .stats.static.os.ostype insert end [lindex $machines($index) 3]
    .stats.static.os.ostype insert end " "
    .stats.static.os.ostype insert end [lindex $machines($index) 5]
    .stats.dynamic.users.num insert end [lindex $machines($index) 6]
    set u  [lindex $machines($index) 6]
#    printmesg "lightblue" "set number of users to: $u"
    .stats.dynamic.users.procs insert end [lindex $machines($index) 15]
    set ut [lindex $machines($index) 7]
    set days [expr $ut/86400]
    set hours [expr [expr $ut%86400]/3600]
    set minutes [expr [expr [expr $ut%86400]%3600]/60]
    set tens [expr $minutes/10]
    set ones [expr $minutes%10]
    set uptime [format "%d days  %2d:%d%d" $days $hours $tens $ones]
#    printmesg "white" "uptime is: $uptime"
    .stats.dynamic.up.uptime insert end $uptime
    .stats.dynamic.loads.load1 insert end [lindex $machines($index) 8]
    .stats.dynamic.loads.load5 insert end [lindex $machines($index) 9]
    .stats.dynamic.loads.load15 insert end [lindex $machines($index) 10]

    # calculate num of ram pixels
    set maxram [expr double([lindex $machines($index) 11])]
    if {$maxram != 0} {
	set rp [expr int(100*double([lindex $machines($index) 12])/$maxram)]
    } else {
	set rp 100
    }
    # update ram bar graph
    if {$rp < 10} {
	set color "red"
    } elseif {$rp < 25} {
	set color "yellow"
    } else {
	set color "green"
    }
    .stats.mem.ram.c create rectangle 3 [expr $rp+3] 24 104 -fill $color -tags bar
#    printmesg $color "percent ram free on $mach is: $rp"
    # update text fields for ram
    set max [expr int([expr [lindex $machines($index) 11]/1024])]
    set cur [expr [expr int([expr [lindex $machines($index) 11]/1024])]-[expr int([expr [lindex $machines($index) 12]/1024])]]
    .stats.mem.ram.max insert end "$max k"
    .stats.mem.ram.cur insert end "$cur k"

    # calculate num of swap pixels
    set maxswap [expr double([lindex $machines($index) 13])]
    if {$maxswap != 0} {
	set sp [expr int([expr 100*[expr double([lindex $machines($index) 14])/$maxswap]])]
    } else {
	set sp 100
    }
    # update swap bar graph
    if {$sp < 10} {
	set color "red"
    } elseif {$sp < 25} {
	set color "yellow"
    } else {
	set color "green"
    }
    .stats.mem.swap.c create rectangle 3 [expr $sp+3] 24 104 -fill $color -tags bar
#    printmesg $color "percent swap free on $mach is: $sp"
    # update text fields for swap
    set max [expr int([expr [lindex $machines($index) 13]/1024])]
    set cur [expr [expr int([expr [lindex $machines($index) 13]/1024])]-[expr int([expr [lindex $machines($index) 14]/1024])]]
    .stats.mem.swap.max insert end "$max k"
    .stats.mem.swap.cur insert end "$cur k"

    # calculate num of block pixels
    set maxblock [expr double([lindex $machines($index) 16])]
    if {$maxblock != 0} {
	set bp [expr int([expr 100*[expr double([lindex $machines($index) 17])/$maxblock]])]
    } else {
	set bp 0
    }
    # update blocks bar graph
    if {$bp < 10} {
	set color "red"
    } elseif {$bp < 25} {
	set color "yellow"
    } else {
	set color "green"
    }
    .stats.disk.blocks.c create rectangle 3 [expr $bp+3] 24 104 -fill $color -tags bar
#    printmesg "lightblue" "percent blocks free on $mach (/) is: $rp"
    # update text fields for blocks
    set max [expr int([lindex $machines($index) 16])]
    set cur [expr [expr int([lindex $machines($index) 16])]-[expr int([lindex $machines($index) 17])]]
    .stats.disk.blocks.max insert end "$max"
    .stats.disk.blocks.cur insert end "$cur"

    # calculate num of inode pixels
    set maxinode [expr double([lindex $machines($index) 18])]
    if {$maxinode != 0} {
	set ip [expr int([expr 100*[expr double([lindex $machines($index) 19])/$maxinode]])]
    } else {
	set ip 0
    }
    # update inode bar graph
    if {$ip < 10} {
	set color "red"
    } elseif {$ip < 25} {
	set color "yellow"
    } else {
	set color "green"
    }
    .stats.disk.inodes.c create rectangle 3 [expr $ip+3] 24 104 -fill $color -tags bar
#    printmesg "lightblue" "percent inodes free on $mach (/) is: $rp"
    # update text fields for inodes
    set max [expr int([lindex $machines($index) 18])]
    set cur [expr [expr int([lindex $machines($index) 18])]-[expr int([lindex $machines($index) 19])]]
    .stats.disk.inodes.max insert end "$max"
    .stats.disk.inodes.cur insert end "$cur"
}

proc clearmessages {} {
    .messages.out delete 1.0 end
    printmesg "lightblue" "Messages Cleared."
}

proc mkprefswindow {} {
    toplevel .prefs
    global lat1
    global lat2
    set len 550
    scale .prefs.poll -label "Polling Interval (seconds):" -from 1 -to 120 -length $len -orient horizontal -variable setpoll
    scale .prefs.cycle -label "Display Cycling Interval (seconds):" -from 0.5 -to 20.0 -resolution 0.1 -orient horizontal -length $len -variable cycletime
    scale .prefs.lds -label "Low Disk Space Warning (percent free):" -from 1 -to 99 -length $len -orient horizontal -variable lds
    scale .prefs.rdst -label "Rapid Disk Space Threshold (percent change per poll):" -from 1 -to 99 -length $len -orient horizontal -variable rdst
    scale .prefs.lss -label "Low Swap Space Warning (percent free):" -from 1 -to 99 -length $len -orient horizontal -variable lss
    scale .prefs.rsst -label "Rapid Swap Space Threshold (percent change per poll):" -from 1 -to 99 -length $len -orient horizontal -variable rsst

    scale .prefs.lat1 -label "High Load Average Warning at load of:" -from 0.1 -to 10.0 -length $len -orient horizontal -command setlat1 -resolution 0.1
    .prefs.lat1 set $lat1
    scale .prefs.lat2 -label "Critical Load Average Warning at load of:" -from 0.1 -to 10.0 -length $len -orient horizontal -command setlat2 -resolution 0.1
    .prefs.lat2 set $lat2
    scale .prefs.procs -label "Process Quantity Threshold:" -from 0 -to 5000 -resolution 10 -orient horizontal -length $len -variable maxnumprocs
    button .prefs.ok -text "OK" -command destroyprefs
    pack .prefs.poll .prefs.cycle .prefs.lds .prefs.rdst .prefs.lss .prefs.rsst .prefs.lat1 .prefs.lat2 .prefs.procs .prefs.ok -side top
    wm title .prefs "SysManager Preferences"
}

proc setlat1 value {
    global lat1
    global lat2
    set lat1 [.prefs.lat1 get]
    if {$lat1 > $lat2} {
	.prefs.lat2 set $lat1
	set lat2 $lat1
    }
}

proc setlat2 value {
    global lat1
    global lat2
    set lat2 [.prefs.lat2 get]
    if {$lat2 < $lat1} {
	.prefs.lat1 set $lat2
	set lat1 $lat2
    }
}

proc destroyprefs {} {
    destroy .prefs
}

proc updatepoll {} {
    global poll
    global setpoll
    global machlist

    set length [llength $machlist]
    if {$length > $setpoll} {
	set poll $length
    } else {
	set poll $setpoll
    }
}

proc mainloop {} {
    global poll
    global curmachine
    if {$curmachine != 0} {
	updatestats $curmachine
    }
    update
    getnewmachines
    updatemachines
    updatepoll
    update
    warnme 0
    after [expr $poll*1000] mainloop
}

proc cycle {} {
    global curmachine
    global machlist
    global cycling
    global cycletime

    if {$cycling == 1 && [llength $machlist] > 0} {
	if {$curmachine != 0} {
	    set nextmach [lindex $machlist [expr ([lsearch $machlist $curmachine]+1)%[llength $machlist]]]
	    updatestats $nextmach
	} else {
	    updatestats [lindex $machlist 0]
	}
    }
    after [expr int(1000*$cycletime)] cycle
}

frame .mbar -relief raised -bd 2
frame .view
frame .messages -bd 2 -relief groove
frame .stats -relief groove
pack .mbar -fill x -side top
pack .messages -side bottom -fill both
pack .stats -side bottom
pack .view -expand 1 -fill both



scrollbar .messages.vscroll -relief sunken -command ".messages.out yview" -background DarkGrey
text .messages.out -yscrollcommand ".messages.vscroll set" -relief sunken -width 40 -height 8 -background Black -foreground Green
label .messages.label -text "SysManager Messages:" -font -adobe-helvetica-*-*-*-*-18-*-*-*-*-*-*-* -background DarkGrey
frame .messages.buttons -background DarkGrey
button .messages.buttons.clear -text "Clear Messages" -command clearmessages -background DarkGrey
button .messages.buttons.warnnow -text "Show All Warnings" -command "warnme 1" -background DarkGrey
pack .messages.buttons.clear .messages.buttons.warnnow -side right
pack .messages.label -side top -fill x
pack .messages.buttons -side bottom -anchor e
pack .messages.out -side left -expand 1 -fill both
pack .messages.vscroll -side right -fill y


scrollbar .view.v -relief sunken -command ".view.c yview"
scrollbar .view.h -relief sunken -command ".view.c xview" -orient horizontal
canvas .view.c -relief sunken -bd 2 -yscrollcommand ".view.v set" -xscrollcommand ".view.h set" -scrollregion {0 0 1000 500}
pack .view.v -side right -fill y
pack .view.h -side bottom -fill x
pack .view.c -side left -fill both -expand 1

frame .stats.static -relief groove -bd 2

frame .stats.static.host
text .stats.static.host.hostname -width 15 -height 1 -relief flat
label .stats.static.host.label -text "Hostname:" -font $labelfont
pack .stats.static.host.label .stats.static.host.hostname -side left

frame .stats.static.arch
text .stats.static.arch.archtype -width 15 -height 1 -relief flat
label .stats.static.arch.label -text "Arch Type:" -font $labelfont
pack .stats.static.arch.label .stats.static.arch.archtype -side left

frame .stats.static.os
text .stats.static.os.ostype -width 15 -height 1 -relief flat
label .stats.static.os.label -text "  OS Type:" -font $labelfont
pack .stats.static.os.label .stats.static.os.ostype -side left

pack .stats.static.host .stats.static.arch .stats.static.os -side top

frame .stats.dynamic -relief groove -bd 2

frame .stats.dynamic.users
text .stats.dynamic.users.num -width 5 -height 1
label .stats.dynamic.users.label -text "Users:" -font $labelfont
text .stats.dynamic.users.procs -width 5 -height 1
label .stats.dynamic.users.proclabel -text "Processes:" -font $labelfont
pack .stats.dynamic.users.label .stats.dynamic.users.num .stats.dynamic.users.proclabel .stats.dynamic.users.procs -side left

frame .stats.dynamic.up
text .stats.dynamic.up.uptime -width 20 -height 1
label .stats.dynamic.up.label -text "Uptime:" -font $labelfont
pack .stats.dynamic.up.label .stats.dynamic.up.uptime -side left

frame .stats.dynamic.loads
label .stats.dynamic.loads.label -text "Load Averages:" -font $labelfont
text .stats.dynamic.loads.load1 -width 4 -height 1
label .stats.dynamic.loads.label1 -text "1 Minute:" -font $labelsmall
text .stats.dynamic.loads.load5 -width 4 -height 1
label .stats.dynamic.loads.label5 -text "5 Minutes:" -font $labelsmall
text .stats.dynamic.loads.load15 -width 4 -height 1
label .stats.dynamic.loads.label15 -text "15 Minutes:" -font $labelsmall
pack .stats.dynamic.loads.label -side top
pack .stats.dynamic.loads.label1 .stats.dynamic.loads.load1 .stats.dynamic.loads.label5 .stats.dynamic.loads.load5 .stats.dynamic.loads.label15 .stats.dynamic.loads.load15 -side left

pack .stats.dynamic.users .stats.dynamic.up .stats.dynamic.loads -side top

frame .stats.mem -relief groove -bd 2

label .stats.mem.label -text "Memory Usage:" -font $labelfont

frame .stats.mem.ram
label .stats.mem.ram.label -text "RAM" -font $labelsmall
canvas .stats.mem.ram.c -relief sunken -bd 2 -width 20 -height 100
text .stats.mem.ram.max -width 7 -height 1 -relief flat -font $small
text .stats.mem.ram.cur -width 7 -height 1 -relief flat -font $small
pack .stats.mem.ram.label .stats.mem.ram.max .stats.mem.ram.c .stats.mem.ram.cur -side top

frame .stats.mem.swap
label .stats.mem.swap.label -text "Swap" -font $labelsmall
canvas .stats.mem.swap.c -relief sunken -bd 2 -width 20 -height 100
text .stats.mem.swap.max -width 7 -height 1 -relief flat -font $small
text .stats.mem.swap.cur -width 7 -height 1 -relief flat -font $small
pack .stats.mem.swap.label .stats.mem.swap.max .stats.mem.swap.c .stats.mem.swap.cur -side top

pack .stats.mem.label -side top
pack .stats.mem.ram .stats.mem.swap -side left -padx 8

frame .stats.disk -relief groove -bd 2

label .stats.disk.label -text "Disk Usage:" -font $labelfont

frame .stats.disk.blocks
label .stats.disk.blocks.label -text "Blocks" -font $labelsmall
canvas .stats.disk.blocks.c -relief sunken -bd 2 -width 20 -height 100
text .stats.disk.blocks.max -width 7 -height 1 -relief flat -font $small
text .stats.disk.blocks.cur -width 7 -height 1 -relief flat -font $small
pack .stats.disk.blocks.label .stats.disk.blocks.max .stats.disk.blocks.c .stats.disk.blocks.cur -side top -padx 8

frame .stats.disk.inodes
label .stats.disk.inodes.label -text "Inodes" -font $labelsmall
canvas .stats.disk.inodes.c -relief sunken -bd 2 -width 20 -height 100
text .stats.disk.inodes.max -width 7 -height 1 -relief flat -font $small
text .stats.disk.inodes.cur -width 7 -height 1 -relief flat -font $small
pack .stats.disk.inodes.label .stats.disk.inodes.max .stats.disk.inodes.c .stats.disk.inodes.cur -side top

pack .stats.disk.label -side top
pack .stats.disk.blocks .stats.disk.inodes -side left

pack .stats.disk .stats.mem -side right -padx 2m -pady 2m
pack .stats.static .stats.dynamic -side top -padx 2m -pady 2m
 

# create menu button and menus

menubutton .mbar.file -text File -underline 0 -menu .mbar.file.m
menu .mbar.file.m
.mbar.file.m add command -label "Quit" -underline 0 -command exit

menubutton .mbar.set -text Settings -underline 0 -menu .mbar.set.m
menu .mbar.set.m
.mbar.set.m add checkbutton -label "Cycle Machines" -variable cycling
#.mbar.set.m add cascade -label "Polling Interval" -menu .mbar.set.m.poll
.mbar.set.m add command -label "Preferences..." -command "mkprefswindow"
pack .mbar.file .mbar.set -side left

#menu .mbar.set.m.poll
#.mbar.set.m.poll add radiobutton -label "1 second" -variable poll -value 1
#.mbar.set.m.poll add radiobutton -label "2 seconds" -variable poll -value 2
#.mbar.set.m.poll add radiobutton -label "5 seconds" -variable poll -value 5
#.mbar.set.m.poll add radiobutton -label "10 seconds" -variable poll -value 10
#.mbar.set.m.poll add radiobutton -label "30 seconds" -variable poll -value 30
#.mbar.set.m.poll add radiobutton -label "60 seconds" -variable poll -value 60

wm title . "SysManager"
wm iconname . "SysManager"
wm minsize . 1 1

printmesg "LightBlue" "SysManager Interface started."

.view.c bind moveable <Button-1> {
    global cycling
#	printmesg "White" "button 1"
    set curX %x
    set curY %y
    set mach [lindex [.view.c gettags [.view.c find withtag current]] 0]
    #	printmesg "lightblue" "You chose the machine: $mach"
    set cycling 0
    updatestats $mach
}
.view.c bind moveable <Double-Button-1> {
    global machines
    global machlist
    set mach [lindex [.view.c gettags [.view.c find withtag current]] 0]
    set ip [lindex $machines([lsearch $machlist $mach]) 20]
#    set ip [lindex [.view.c gettags [.view.c find withtag current]] 20]
    printmesg "blue" "Opening terminal to $mach ($ip)"
    exec xterm -T "$mach" -e telnet $ip &
}

.view.c bind moveable <B1-Motion> {
    # set mach to <machine>
    set mach [lindex [.view.c gettags [.view.c find withtag current]] 0]
#    printmesg "white" "mach is $mach"
    set item1 [lindex [.view.c find withtag $mach] 0]
    set item2 [lindex [.view.c find withtag $mach] 1]
#    printmesg "white" "item 1 is $item1"
#    printmesg "white" "item 2 is $item2"
    .view.c move $item1 [expr %x-$curX] [expr %y-$curY]
    .view.c move $item2 [expr %x-$curX] [expr %y-$curY]
    set curX %x
    set curY %y
}




for {set i 0} {$i < $argc} {incr i 1} {
    set arg [lindex $argv $i]
    if {$arg == "-p"} {
	set port [lindex $argv [incr i 1]]
    } else {
	    set host $arg
    }
}

mainloop
cycle






