/* server.h

   This is the header file for server.c which contains the main chunk
   of code for serverd.

*/

/* Define the message structure that is passed between forked child and
   parent. */
struct mymsg {
  long mtype;
  int  poll_time;
  int  registered;
  char ip[16];
  char info[1997];
};


/* Structure used as the points on a doubly linked list that contains
   machine information */
struct machine {
  char *info;            /* Most recently retrieved info about the machine */
  char *ip;              /* needed to recontact host */
  struct machine *next;  /* Pointer to next Machine */
  struct machine *prev;  /* Pointer to previous Machine */
  int  warncount;        /* Times in a row we couldn't gather info */
};

/* The default port for clients to connect to us: */
#define SERVERD_PORT	5055
#define CLIENTD_PORT    5005

/* The default file to which the server logs errors: */
#define SERVER_LOG	"/tmp/serverd.log"

#define DEFAULT_WAIT 4 /* poll_time on initial startup */
#define WAIT_MULT 4    
#define TRUE 1         /* Always handy TRUE and FALSE Definitions. */
#define FALSE 0

/* Size of Message to send down the message queue */
#define MSGSIZE (sizeof(struct mymsg) - sizeof(long)) 

/* When to complain about not finding machine */
#define WARNCOUNTLIMIT 4 

/* Global vars.  

   Note that most of these are necessary because of the dependency on
   interrupt handlers which need to either know about or modify them.
*/

char    *pname;			/* Server program name. */
int      poll_time;             /* Time interval to poll (sec) */
char    *register_to;           /* Machine to register to */
int      msqid;                 /* Message queue ID */
int      NumberOfMachines;      /* Total Number of Machines registered */
int      ZeroMachines;          /* Boolean to Zero NumberOfMachines */
struct machine *current;        /* Pointer to machine being processed */
int      isockfd;               /* Incoming socket file descriptor */


