/* handlers.c 

   This file contains the code that is used to handle any signals that are
   raised in server.c

*/

#include        <stdio.h>
#include        <string.h>
#include        <unistd.h>
#include        <stdlib.h>
#include        <errno.h>
#include        <stdarg.h>
#include        <time.h>
#include        <fcntl.h>
#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netdb.h>
#include        <netinet/in.h>
#include        <sys/ipc.h>
#include        <sys/msg.h>
#include        <signal.h>
#include        <arpa/inet.h>

#include	"sig.h"
#include	"daemon.h"
#include        "handlers.h"
#include        "server.h"
#include        "machinefuncs.h"


void printlog(char *, ...);

void
check_msg_queue(int signo)
{
  struct mymsg *message;
  
#ifdef DEBUG
  fprintf(stderr,"Checking message queue:\n");
#endif

  message = (struct mymsg *)  malloc(sizeof(struct mymsg));

  /* Handle a message of type 1.  (Chang the polling interval) */
  if ( msgrcv(msqid, (void *) message, MSGSIZE, 1, IPC_NOWAIT) 
       > 0) {
    message = (struct mymsg *) message;

    /* Assure polling happens no more than once a second */
    if (message->poll_time > NumberOfMachines) { 
      poll_time = message->poll_time;
    } else {
      poll_time = NumberOfMachines;
    }
  }

  /* Handle a message of type 3.  (Update a machines information) */
  if (msgrcv(msqid, (void *) message, MSGSIZE, 3, IPC_NOWAIT) 
      > 0) {  /* String of Info */

    message = (struct mymsg *) message;

#ifdef DEBUG
    fprintf(stderr,"Updating information for: %s\n",message->ip);
#endif

    update_machine(message->ip, message->info);
  }


  /* Handle a message of type 3.  (couldn't connect to machine) */
  if (msgrcv(msqid, (void *) message, MSGSIZE, 4, IPC_NOWAIT) 
      > 0) {  /* String of Info */
    message = (struct mymsg *) message;
    warn_machine(message->ip);
  }

  free(message);
  signal(SIGUSR1,check_msg_queue);
}


void async_request(int signo)
{
  int			newsockfd, clilen;
  struct sockaddr_in	cli_addr;
  FILE		       *fdin, *fdout;
  char                 ipaddr[16];

#ifdef DEBUG
  fprintf(stderr,"In registration Request.\n");
#endif

  /* Set up networking for below */
  clilen = sizeof(cli_addr);
  newsockfd = accept(isockfd, (struct sockaddr *) &cli_addr,
		     (int *) &clilen);
  if (newsockfd < 0) {
    printlog ("accept error-- errno: %d", errno);
    return;
  }
  
  
  /*
   * Associate stdio lib file descriptors with the socket.
   * This allows us to use fprintf, fscanf, etc. instead of
   * read, write.
   */

  fdin  = fdopen (newsockfd, "r");
  fdout = fdopen (newsockfd, "w");

  /*
   * Non-tty devices are not line-buffered by default.
   * This allows us to get and send lines as soon as they
   * are available.
   */

  setvbuf (fdin,  NULL, _IOLBF, 0);
  setvbuf (fdout, NULL, _IOLBF, 0);


  /* Translate xxxxxxxx to xxx.xxx.xxx.xxx */
  strcpy(ipaddr,(char *) inet_ntoa(cli_addr.sin_addr));
 

  
  client_interaction(fdin, fdout, ipaddr);


  close (newsockfd);    /* For good measure... */
  

}




/*
 * This function handles all our interaction with the client.
 * 'client_id' is a unique integer representing the client.
 */
void
client_interaction (FILE *fdin, FILE*fdout, char *ipaddr)
{
	char   buf[512];
	int    i;
	struct machine *temp;

#ifdef DEBUG
	fprintf(stderr,"In client interaction\n"); 
#endif

	/*
         * Loop, handling the client's requests, until the client
	 * closes the connection or we take action to drop it.
         */
	while (fgets (buf, sizeof(buf), fdin) != NULL) {
	  
	  
	  
	  /* get rid of control characters. */
	  for (i = 0; i < sizeof(buf); ++i)
	    if (buf[i] < 32) buf[i] = 0;
	  

	  /* BYE command -- client wants to quit. */
	  if (! strcmp(buf, "QUIT")) {
	    break;
	  }

	  /* Command to remove a machine from the list */
	  else if (! strncmp(buf, "NUKE!", 5)) {
	    if (buf[5] != 0 && buf[6] != 0)
	      remove_machine(buf+6);
	    
	  }
	  
	  /* Command to return all the Serverds list information */
	  else if (! strcmp(buf, "SPEWFORTHALL")) {
	    if (current == 0 || current->info == 0) { /* No Machines */
	      fprintf(fdout,"\n");
	    } else {                                  /* Loop and print */
	      printf("%s",current->info); 
	      fprintf(fdout,"%s",current->info);
	      temp = current->next;
		    while(temp != current) {
		      fprintf(fdout,"%s",temp->info);
		      temp = temp->next;
		    }
		    fprintf(fdout,"\n");
	    }
	  }
	  
	  /* Add a new machine to gather information from. */
	  else if (! strncmp(buf, "NEWCLIENT", 9)) {
	    add_machine(ipaddr);
	  }

	  /* Set the pollint interval */
	  else if (! strncmp(buf, "POLL", 4)) {
	    /* Insure that no more than one machine per second is polled */
	    if (atoi(buf+5) > NumberOfMachines) {
	      poll_time = atoi(buf+5);
	    } else {
	      poll_time = NumberOfMachines;
	    }
	  }
	  
	  /* We don't understand the request... */
	  else {
	    fprintf (fdout, "\n");
	  }
	}
	
	fclose (fdin);
	fclose (fdout);
	
}

/* Remove the message Queue ID on exit so the system will be happier */
void remove_msq(int signo)
{
  msgctl(msqid, IPC_RMID, 0);
  fprintf(stderr,"Goodbye!!\n");
  exit(0);
}

